/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices.script;

import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.client.config.ElasticsearchVersion;
import io.searchbox.indices.script.ScriptLanguage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class AbstractStoredScript
extends GenericResultAbstractAction {
    protected String scriptName;
    protected ScriptLanguage scriptLanguage;

    protected AbstractStoredScript(Builder builder) {
        super(builder);
        this.scriptName = builder.scriptName;
        this.scriptLanguage = builder.scriptLanguage;
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        String finalUri = super.buildURI(elasticsearchVersion) + "/_scripts/";
        try {
            finalUri = finalUri + URLEncoder.encode(this.scriptName, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error occurred while adding parameters to uri.", e);
        }
        return finalUri;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public static abstract class Builder<T extends AbstractStoredScript, K>
    extends AbstractAction.Builder<T, K> {
        private String scriptName;
        protected ScriptLanguage scriptLanguage = ScriptLanguage.PAINLESS;

        public Builder(String scriptName) {
            this.scriptName = scriptName;
        }

        public K setLanguage(ScriptLanguage scriptLanguage) {
            this.scriptLanguage = scriptLanguage;
            return (K)this;
        }
    }
}

