/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices;

import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.client.config.ElasticsearchVersion;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Analyze
extends GenericResultAbstractAction {
    protected Analyze(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        this.payload = builder.body;
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        return super.buildURI(elasticsearchVersion) + "/_analyze";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(Gson gson) {
        return gson.toJson(this.payload, (Type)((Object)Map.class));
    }

    public static class Builder
    extends AbstractAction.Builder<Analyze, Builder> {
        private String index;
        private List<String> textToAnalyze = new ArrayList<String>();
        private List<String> filters = new ArrayList<String>();
        private Map<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("text", textToAnalyze);
                this.put("filter", filters);
            }
        };

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder text(String textToAnalyze) {
            this.textToAnalyze.add(textToAnalyze);
            return this;
        }

        public Builder text(Collection<? extends String> textToAnalyze) {
            this.textToAnalyze.addAll(textToAnalyze);
            return this;
        }

        public Builder analyzer(String analyzer) {
            this.body.put("analyzer", analyzer);
            return this;
        }

        public Builder field(String field) {
            this.body.put("field", field);
            return this;
        }

        public Builder tokenizer(String tokenizer) {
            this.body.put("tokenizer", tokenizer);
            return this;
        }

        public Builder filter(String filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder filter(Collection<? extends String> filters) {
            this.filters.addAll(filters);
            return this;
        }

        @Override
        public Analyze build() {
            return new Analyze(this);
        }
    }
}

