/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.base.CharMatcher;
import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.client.config.ElasticsearchVersion;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import io.searchbox.strings.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class MultiSearch
extends AbstractAction<MultiSearchResult> {
    private static final CharMatcher NEWLINE_MATCHER = CharMatcher.anyOf("\r\n").precomputed();
    private Collection<Search> searches;

    protected MultiSearch(Builder builder) {
        super(builder);
        this.searches = builder.searchList;
    }

    @Override
    public MultiSearchResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        return this.createNewElasticSearchResult(new MultiSearchResult(gson), responseBody, statusCode, reasonPhrase, gson);
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(Gson gson) {
        StringBuilder sb = new StringBuilder();
        for (Search search : this.searches) {
            sb.append("{\"index\" : \"").append(search.getIndex());
            if (StringUtils.isNotBlank(search.getType())) {
                sb.append("\", \"type\" : \"").append(search.getType());
            }
            sb.append(this.getParameter(search, "ignore_unavailable"));
            sb.append(this.getParameter(search, "allow_no_indices"));
            sb.append(this.getParameter(search, "expand_wildcards"));
            String query = NEWLINE_MATCHER.removeFrom(search.getData(gson));
            sb.append("\"}\n").append(query).append("\n");
        }
        return sb.toString();
    }

    private String getParameter(Search search, String parameter) {
        Collection<Object> searchParameter = search.getParameter(parameter);
        if (searchParameter != null) {
            int parameters = searchParameter.size();
            if (parameters == 1) {
                return "\", \"" + parameter + "\" : \"" + searchParameter.iterator().next();
            }
            if (parameters > 1) {
                throw new IllegalArgumentException("Expecting a single value for '" + parameter + "' parameter, you provided: " + parameters);
            }
        }
        return "";
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        return super.buildURI(elasticsearchVersion) + "/_msearch";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.searches);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MultiSearch rhs = (MultiSearch)obj;
        return super.equals(obj) && Objects.equals(this.searches, rhs.searches);
    }

    public static class Builder
    extends AbstractAction.Builder<MultiSearch, Builder> {
        private List<Search> searchList = new LinkedList<Search>();

        public Builder(Search search) {
            this.setHeader("Content-Type", "application/x-ndjson");
            this.searchList.add(search);
        }

        public Builder(Collection<? extends Search> searches) {
            this.setHeader("Content-Type", "application/x-ndjson");
            this.searchList.addAll(searches);
        }

        public Builder addSearch(Search search) {
            this.searchList.add(search);
            return this;
        }

        public Builder addSearch(Collection<? extends Search> searches) {
            this.searchList.addAll(searches);
            return this;
        }

        @Override
        public MultiSearch build() {
            return new MultiSearch(this);
        }
    }
}

