/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import java.util.ArrayList;
import java.util.Map;

public class CatResult
extends JestResult {
    public CatResult(CatResult catResult) {
        super(catResult);
    }

    public CatResult(Gson gson) {
        super(gson);
    }

    public String[][] getPlainText() {
        JsonArray esResultRows;
        JsonObject jsonObject = this.getJsonObject();
        if (jsonObject != null && jsonObject.has(this.getPathToResult()) && jsonObject.get(this.getPathToResult()).isJsonArray() && (esResultRows = jsonObject.get(this.getPathToResult()).getAsJsonArray()).size() > 0 && esResultRows.get(0).isJsonObject()) {
            return this.parseResultArray(esResultRows);
        }
        return new String[0][0];
    }

    private String[][] parseResultArray(JsonArray esResponse) {
        ArrayList<Map.Entry<String, JsonElement>> fieldsInFirstResponseRow = Lists.newArrayList(esResponse.get(0).getAsJsonObject().entrySet());
        String[][] result = new String[esResponse.size() + 1][fieldsInFirstResponseRow.size()];
        for (int i = 0; i < fieldsInFirstResponseRow.size(); ++i) {
            result[0][i] = (String)((Map.Entry)fieldsInFirstResponseRow.get(i)).getKey();
        }
        int rowNum = 1;
        for (JsonElement row : esResponse) {
            JsonObject currentObj = row.getAsJsonObject();
            for (int colId = 0; colId < fieldsInFirstResponseRow.size(); ++colId) {
                result[rowNum][colId] = currentObj.get(result[0][colId]).getAsString();
            }
            ++rowNum;
        }
        return result;
    }
}

