/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiINodeActionBuilder;
import io.searchbox.action.AbstractMultiIndexActionBuilder;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.client.config.ElasticsearchVersion;
import io.searchbox.core.CatResult;
import io.searchbox.strings.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Cat
extends AbstractAction<CatResult> {
    private static final String PATH_TO_RESULT = "result";
    private final String operationPath;

    protected <T extends AbstractAction.Builder<Cat, ? extends AbstractAction.Builder>> Cat(T builder) {
        super(builder);
        this.operationPath = ((CatBuilder)((Object)builder)).operationPath();
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        String uriSuffix = super.buildURI(elasticsearchVersion);
        try {
            if (!StringUtils.isBlank(this.nodes)) {
                uriSuffix = uriSuffix + URLEncoder.encode(this.nodes, CHARSET);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error occurred while adding nodes to uri", e);
        }
        return "_cat/" + this.operationPath + (uriSuffix.isEmpty() ? "" : "/") + uriSuffix;
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    @Override
    public String getPathToResult() {
        return PATH_TO_RESULT;
    }

    @Override
    public CatResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        return this.createNewElasticSearchResult(new CatResult(gson), responseBody, statusCode, reasonPhrase, gson);
    }

    @Override
    protected JsonObject parseResponseBody(String responseBody) {
        if (responseBody == null || responseBody.trim().isEmpty()) {
            return new JsonObject();
        }
        JsonElement parsed = new JsonParser().parse(responseBody);
        if (parsed.isJsonArray()) {
            JsonObject result = new JsonObject();
            result.add(PATH_TO_RESULT, parsed.getAsJsonArray());
            return result;
        }
        throw new JsonSyntaxException("Cat response did not contain a JSON Array");
    }

    protected static interface CatBuilder {
        public String operationPath();
    }

    public static class AllocationBuilder
    extends AbstractMultiINodeActionBuilder<Cat, AllocationBuilder>
    implements CatBuilder {
        private static final String operationPath = "allocation";

        public AllocationBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }

        @Override
        public String getJoinedNodes() {
            return this.nodes.isEmpty() ? null : Joiner.on(',').join(this.nodes);
        }
    }

    public static class NodesBuilder
    extends AbstractAction.Builder<Cat, NodesBuilder>
    implements CatBuilder {
        private static final String operationPath = "nodes";

        public NodesBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }
    }

    public static class SegmentsBuilder
    extends AbstractMultiIndexActionBuilder<Cat, SegmentsBuilder>
    implements CatBuilder {
        private static final String operationPath = "segments";

        public SegmentsBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }

        @Override
        public String getJoinedIndices() {
            return this.indexNames.size() > 0 ? Joiner.on(',').join(this.indexNames) : null;
        }
    }

    public static class ShardsBuilder
    extends AbstractMultiIndexActionBuilder<Cat, ShardsBuilder>
    implements CatBuilder {
        private static final String operationPath = "shards";

        public ShardsBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }

        @Override
        public String getJoinedIndices() {
            if (this.indexNames.size() > 0) {
                return Joiner.on(',').join(this.indexNames);
            }
            return null;
        }
    }

    public static class RecoveryBuilder
    extends AbstractMultiIndexActionBuilder<Cat, RecoveryBuilder>
    implements CatBuilder {
        private static final String operationPath = "recovery";

        public RecoveryBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }
    }

    public static class AliasesBuilder
    extends AbstractMultiIndexActionBuilder<Cat, AliasesBuilder>
    implements CatBuilder {
        private static final String operationPath = "aliases";

        public AliasesBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }
    }

    public static class IndicesBuilder
    extends AbstractMultiTypeActionBuilder<Cat, IndicesBuilder>
    implements CatBuilder {
        private static final String operationPath = "indices";

        public IndicesBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }
    }
}

