/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.action;

import io.searchbox.action.AbstractAction;
import io.searchbox.action.DocumentTargetedAction;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.ElasticsearchVersion;
import io.searchbox.strings.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class AbstractDocumentTargetedAction<T extends JestResult>
extends AbstractAction<T>
implements DocumentTargetedAction<T> {
    protected String id;

    public AbstractDocumentTargetedAction(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.id = builder.id;
    }

    @Override
    public String getIndex() {
        return this.indexName;
    }

    @Override
    public String getType() {
        return this.typeName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        StringBuilder sb = new StringBuilder(super.buildURI(elasticsearchVersion));
        if (StringUtils.isNotBlank(this.id)) {
            try {
                sb.append("/").append(URLEncoder.encode(this.id, CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                log.error("Error occurred while adding document id to uri.", e);
            }
        }
        return sb.toString();
    }

    protected static abstract class Builder<T extends AbstractDocumentTargetedAction, K>
    extends AbstractAction.Builder<T, K> {
        private String index;
        private String type;
        private String id;

        protected Builder() {
        }

        public K index(String index) {
            this.index = index;
            return (K)this;
        }

        public K type(String type) {
            this.type = type;
            return (K)this;
        }

        public K id(String id) {
            this.id = id;
            return (K)this;
        }
    }
}

