/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import java.util.Map;
import java.util.Objects;

public class CreateIndex
extends GenericResultAbstractAction {
    private Object aliases;
    private Object settings;
    private Object mappings;

    protected CreateIndex(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        this.payload = builder.payload;
        this.aliases = builder.aliases;
        this.settings = builder.settings;
        this.mappings = builder.mappings;
        this.setURI(this.buildURI());
    }

    @Override
    public String getData(Gson gson) {
        if (this.payload != null) {
            if (this.payload instanceof String) {
                return (String)this.payload;
            }
            if (this.payload instanceof Map) {
                return gson.toJson(this.payload);
            }
        } else {
            JsonObject jsonObject = new JsonObject();
            if (this.aliases != null) {
                if (this.aliases instanceof String) {
                    jsonObject.add("aliases", gson.fromJson(this.aliases.toString(), JsonElement.class));
                } else if (this.aliases instanceof Map) {
                    jsonObject.add("aliases", gson.toJsonTree(this.aliases));
                }
            }
            if (this.settings != null) {
                if (this.settings instanceof String) {
                    jsonObject.add("settings", gson.fromJson(this.settings.toString(), JsonElement.class));
                } else if (this.settings instanceof Map) {
                    jsonObject.add("settings", gson.toJsonTree(this.settings));
                }
            }
            if (this.mappings != null) {
                if (this.mappings instanceof String) {
                    jsonObject.add("mappings", gson.fromJson(this.mappings.toString(), JsonElement.class));
                } else if (this.mappings instanceof Map) {
                    jsonObject.add("mappings", gson.toJsonTree(this.mappings));
                }
            }
            if (jsonObject.size() == 0) {
                return null;
            }
            return jsonObject.toString();
        }
        return null;
    }

    @Override
    public String getRestMethodName() {
        return "PUT";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.indexName, this.payload);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CreateIndex rhs = (CreateIndex)obj;
        return super.equals(obj) && Objects.equals(this.indexName, rhs.indexName) && Objects.equals(this.payload, rhs.payload) && Objects.equals(this.settings, rhs.settings) && Objects.equals(this.mappings, rhs.mappings) && Objects.equals(this.aliases, rhs.aliases);
    }

    public static class Builder
    extends AbstractAction.Builder<CreateIndex, Builder> {
        private Object payload = null;
        private Object settings = null;
        private Object mappings = null;
        private Object aliases = null;
        private String index;

        public Builder(String index) {
            this.index = index;
        }

        public Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public Builder payload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public Builder settings(String settings) {
            this.settings = settings;
            return this;
        }

        public Builder settings(Map<String, Object> settings) {
            this.settings = settings;
            return this;
        }

        public Builder mappings(String mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder mappings(Map<String, Object> mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder aliases(String aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder aliases(Map<String, Object> aliases) {
            this.aliases = aliases;
            return this;
        }

        @Override
        public CreateIndex build() {
            return new CreateIndex(this);
        }
    }
}

