/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices.script;

import com.google.common.io.CharStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.action.AbstractAction;
import io.searchbox.indices.script.AbstractStoredScript;
import io.searchbox.indices.script.ScriptLanguage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class CreateStoredScript
extends AbstractStoredScript {
    protected CreateStoredScript(Builder builder) {
        super(builder);
        this.payload = builder.payload;
        this.setURI(this.buildURI());
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public static class Builder
    extends AbstractStoredScript.Builder<CreateStoredScript, Builder> {
        private JsonElement payload;

        public Builder(String scriptName) {
            super(scriptName);
        }

        @Override
        public CreateStoredScript build() {
            return new CreateStoredScript(this);
        }

        public Builder setSource(String source) {
            this.createPayload(source);
            return this;
        }

        public Builder loadSource(File srcFile) throws IOException {
            return this.loadSource(srcFile, Charset.forName(AbstractAction.CHARSET));
        }

        public Builder loadSource(File srcFile, Charset encoding) throws IOException {
            return this.loadSource(new FileInputStream(srcFile), encoding);
        }

        public Builder loadSource(InputStream srcStream) throws IOException {
            return this.loadSource(srcStream, Charset.forName(AbstractAction.CHARSET));
        }

        public Builder loadSource(InputStream srcStream, Charset encoding) throws IOException {
            String src = CharStreams.toString(new InputStreamReader(srcStream, encoding));
            this.createPayload(src);
            return this;
        }

        private void createPayload(String source) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("script", source);
            this.payload = jsonObject;
        }
    }
}

