/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.action;

import com.google.common.base.Joiner;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.Action;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractMultiIndexActionBuilder<T extends Action, K>
extends AbstractAction.Builder<T, K> {
    protected Set<String> indexNames = new LinkedHashSet<String>();

    public K addIndex(String indexName) {
        this.indexNames.add(indexName);
        return (K)this;
    }

    public K addIndex(Collection<? extends String> indexNames) {
        this.indexNames.addAll(indexNames);
        return (K)this;
    }

    public K ignoreUnavailable(boolean ignore) {
        this.setParameter("ignore_unavailable", String.valueOf(ignore));
        return (K)this;
    }

    public K allowNoIndices(boolean allow) {
        this.setParameter("allow_no_indices", String.valueOf(allow));
        return (K)this;
    }

    public String getJoinedIndices() {
        if (this.indexNames.size() > 0) {
            return Joiner.on(',').join(this.indexNames);
        }
        return "_all";
    }

    @Override
    public abstract T build();
}

