/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.action;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.Action;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractMultiINodeActionBuilder<T extends Action, K>
extends AbstractAction.Builder<T, K> {
    private Collection<String> nodes = new LinkedList<String>();

    public K addNode(String node) {
        if (!Strings.isNullOrEmpty(node)) {
            this.nodes.add(node);
        }
        return (K)this;
    }

    public K addNode(Collection<? extends String> nodes) {
        this.nodes.addAll(nodes);
        return (K)this;
    }

    public String getJoinedNodes() {
        if (!this.nodes.isEmpty()) {
            return Joiner.on(',').join(this.nodes);
        }
        return "_all";
    }

    @Override
    public abstract T build();
}

