/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class MultiSearch
extends AbstractAction<MultiSearchResult> {
    private Collection<Search> searches;

    protected MultiSearch(Builder builder) {
        super(builder);
        this.searches = builder.searchList;
        this.setURI(this.buildURI());
    }

    @Override
    public MultiSearchResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        return this.createNewElasticSearchResult(new MultiSearchResult(gson), responseBody, statusCode, reasonPhrase, gson);
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(Gson gson) {
        StringBuilder sb = new StringBuilder();
        for (Search search : this.searches) {
            sb.append("{\"index\" : \"").append(search.getIndex());
            if (StringUtils.isNotBlank(search.getType())) {
                sb.append("\", \"type\" : \"").append(search.getType());
            }
            sb.append(this.getParameter(search, "ignore_unavailable"));
            sb.append(this.getParameter(search, "allow_no_indices"));
            sb.append(this.getParameter(search, "expand_wildcards"));
            sb.append("\"}\n").append(search.getData(gson)).append("\n");
        }
        return sb.toString();
    }

    private String getParameter(Search search, String parameter) {
        Collection<Object> searchParameter = search.getParameter(parameter);
        if (searchParameter != null && searchParameter != null) {
            if (searchParameter.size() == 1) {
                return "\", \"" + parameter + "\" : \"" + searchParameter.iterator().next();
            }
            if (searchParameter.size() > 1) {
                throw new IllegalArgumentException("Expecting a single value for '" + parameter + "' parameter, you provided: " + searchParameter.size());
            }
        }
        return "";
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_msearch";
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.searches).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MultiSearch rhs = (MultiSearch)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.searches, rhs.searches).isEquals();
    }

    public static class Builder
    extends AbstractAction.Builder<MultiSearch, Builder> {
        private List<Search> searchList = new LinkedList<Search>();

        public Builder(Search search) {
            this.searchList.add(search);
        }

        public Builder(Collection<? extends Search> searches) {
            this.searchList.addAll(searches);
        }

        public Builder addSearch(Search search) {
            this.searchList.add(search);
            return this;
        }

        public Builder addSearch(Collection<? extends Search> searches) {
            this.searchList.addAll(searches);
            return this;
        }

        @Override
        public MultiSearch build() {
            return new MultiSearch(this);
        }
    }
}

