/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ClientConfig {
    private Set<String> serverList;
    private boolean isMultiThreaded;
    private boolean isDiscoveryEnabled;
    private String discoveryFilter;
    private boolean isRequestCompressionEnabled;
    private int connTimeout;
    private int readTimeout;
    private long discoveryFrequency;
    private long maxConnectionIdleTime;
    private TimeUnit discoveryFrequencyTimeUnit;
    private TimeUnit maxConnectionIdleTimeDurationTimeUnit;
    private Gson gson;
    private String defaultSchemeForDiscoveredNodes;

    private ClientConfig() {
    }

    public ClientConfig(AbstractBuilder builder) {
        this.serverList = builder.serverList;
        this.isMultiThreaded = builder.isMultiThreaded;
        this.isDiscoveryEnabled = builder.isDiscoveryEnabled;
        this.discoveryFilter = builder.discoveryFilter;
        this.isRequestCompressionEnabled = builder.isRequestCompressionEnabled;
        this.discoveryFrequency = builder.discoveryFrequency;
        this.discoveryFrequencyTimeUnit = builder.discoveryFrequencyTimeUnit;
        this.connTimeout = builder.connTimeout;
        this.readTimeout = builder.readTimeout;
        this.maxConnectionIdleTime = builder.maxConnectionIdleTime;
        this.maxConnectionIdleTimeDurationTimeUnit = builder.maxConnectionIdleTimeDurationTimeUnit;
        this.gson = builder.gson;
        this.defaultSchemeForDiscoveredNodes = builder.defaultSchemeForDiscoveredNodes;
    }

    public Set<String> getServerList() {
        return this.serverList;
    }

    public boolean isMultiThreaded() {
        return this.isMultiThreaded;
    }

    public boolean isDiscoveryEnabled() {
        return this.isDiscoveryEnabled;
    }

    public String getDiscoveryFilter() {
        return this.discoveryFilter;
    }

    public Long getDiscoveryFrequency() {
        return this.discoveryFrequency;
    }

    public TimeUnit getDiscoveryFrequencyTimeUnit() {
        return this.discoveryFrequencyTimeUnit;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public long getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public TimeUnit getMaxConnectionIdleTimeDurationTimeUnit() {
        return this.maxConnectionIdleTimeDurationTimeUnit;
    }

    public Gson getGson() {
        return this.gson;
    }

    public String getDefaultSchemeForDiscoveredNodes() {
        return this.defaultSchemeForDiscoveredNodes;
    }

    public boolean isRequestCompressionEnabled() {
        return this.isRequestCompressionEnabled;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.serverList).append(this.isMultiThreaded).append(this.isDiscoveryEnabled).append(this.isRequestCompressionEnabled).append(this.discoveryFrequency).append(this.discoveryFilter).append(this.connTimeout).append(this.readTimeout).append((Object)this.discoveryFrequencyTimeUnit).append(this.maxConnectionIdleTime).append((Object)this.maxConnectionIdleTimeDurationTimeUnit).append(this.gson).append(this.defaultSchemeForDiscoveredNodes).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClientConfig rhs = (ClientConfig)obj;
        return new EqualsBuilder().append(this.serverList, rhs.serverList).append(this.isMultiThreaded, rhs.isMultiThreaded).append(this.isDiscoveryEnabled, rhs.isDiscoveryEnabled).append(this.isRequestCompressionEnabled, rhs.isRequestCompressionEnabled).append(this.discoveryFrequency, rhs.discoveryFrequency).append(this.discoveryFilter, rhs.discoveryFilter).append(this.connTimeout, rhs.connTimeout).append(this.readTimeout, rhs.readTimeout).append((Object)this.discoveryFrequencyTimeUnit, (Object)rhs.discoveryFrequencyTimeUnit).append(this.maxConnectionIdleTime, rhs.maxConnectionIdleTime).append((Object)this.maxConnectionIdleTimeDurationTimeUnit, (Object)rhs.maxConnectionIdleTimeDurationTimeUnit).append(this.gson, rhs.gson).append(this.defaultSchemeForDiscoveredNodes, rhs.defaultSchemeForDiscoveredNodes).isEquals();
    }

    protected static abstract class AbstractBuilder<T extends ClientConfig, K extends AbstractBuilder<T, K>> {
        protected Set<String> serverList = new LinkedHashSet<String>();
        protected boolean isMultiThreaded;
        protected boolean isDiscoveryEnabled;
        protected String discoveryFilter;
        protected boolean isRequestCompressionEnabled;
        protected long discoveryFrequency = 10L;
        protected long maxConnectionIdleTime = -1L;
        protected Integer maxTotalConnection;
        protected Integer defaultMaxTotalConnectionPerRoute;
        protected Integer connTimeout = 3000;
        protected Integer readTimeout = 3000;
        protected TimeUnit discoveryFrequencyTimeUnit = TimeUnit.SECONDS;
        protected TimeUnit maxConnectionIdleTimeDurationTimeUnit = TimeUnit.SECONDS;
        protected Gson gson;
        protected String defaultSchemeForDiscoveredNodes = "http://";

        public AbstractBuilder(Collection<String> serverUris) {
            this.serverList.addAll(serverUris);
        }

        public AbstractBuilder(String serverUri) {
            this.serverList.add(serverUri);
        }

        public AbstractBuilder(ClientConfig clientConfig) {
            this.serverList = clientConfig.serverList;
            this.isMultiThreaded = clientConfig.isMultiThreaded;
            this.isDiscoveryEnabled = clientConfig.isDiscoveryEnabled;
            this.discoveryFrequency = clientConfig.discoveryFrequency;
            this.discoveryFilter = clientConfig.discoveryFilter;
            this.discoveryFrequencyTimeUnit = clientConfig.discoveryFrequencyTimeUnit;
            this.connTimeout = clientConfig.connTimeout;
            this.readTimeout = clientConfig.readTimeout;
            this.gson = clientConfig.gson;
        }

        public K addServer(String serverUri) {
            this.serverList.add(serverUri);
            return (K)this;
        }

        public K addServer(Collection<String> serverUris) {
            this.serverList.addAll(serverUris);
            return (K)this;
        }

        public K gson(Gson gson) {
            this.gson = gson;
            return (K)this;
        }

        public K discoveryFrequency(long discoveryFrequency, TimeUnit discoveryFrequencyTimeUnit) {
            this.discoveryFrequency = discoveryFrequency;
            this.discoveryFrequencyTimeUnit = discoveryFrequencyTimeUnit;
            return (K)this;
        }

        public K discoveryEnabled(boolean isDiscoveryEnabled) {
            this.isDiscoveryEnabled = isDiscoveryEnabled;
            return (K)this;
        }

        public K discoveryFilter(String discoveryFilter) {
            this.discoveryFilter = discoveryFilter;
            return (K)this;
        }

        public K multiThreaded(boolean isMultiThreaded) {
            this.isMultiThreaded = isMultiThreaded;
            return (K)this;
        }

        public K requestCompressionEnabled(boolean isRequestCompressionEnabled) {
            this.isRequestCompressionEnabled = isRequestCompressionEnabled;
            return (K)this;
        }

        public K connTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return (K)this;
        }

        public K readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return (K)this;
        }

        public K maxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
            return (K)this;
        }

        public K defaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
            this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
            return (K)this;
        }

        public K maxConnectionIdleTime(long duration, TimeUnit maxConnectionIdleTimeDurationTimeUnit) {
            this.maxConnectionIdleTime = duration;
            this.maxConnectionIdleTimeDurationTimeUnit = maxConnectionIdleTimeDurationTimeUnit;
            return (K)this;
        }

        public K defaultSchemeForDiscoveredNodes(String defaultSchemeForDiscoveredNodes) {
            this.defaultSchemeForDiscoveredNodes = defaultSchemeForDiscoveredNodes + "://";
            return (K)this;
        }

        public abstract T build();
    }

    public static class Builder
    extends AbstractBuilder<ClientConfig, Builder> {
        public Builder(ClientConfig clientConfig) {
            super(clientConfig);
        }

        public Builder(Collection<String> serverUris) {
            super(serverUris);
        }

        public Builder(String serverUri) {
            super(serverUri);
        }

        @Override
        public ClientConfig build() {
            return new ClientConfig(this);
        }
    }
}

