/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.AndroidLoggerAdapter;

class AndroidLoggerFactory
implements ILoggerFactory {
    static final String ANONYMOUS_TAG = "null";
    static final int TAG_MAX_LENGTH = 23;
    private final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    AndroidLoggerFactory() {
    }

    public Logger getLogger(String name) {
        String tag = AndroidLoggerFactory.loggerNameToTag(name);
        Logger logger = (Logger)this.loggerMap.get(tag);
        if (logger == null) {
            AndroidLoggerAdapter newInstance = new AndroidLoggerAdapter(tag);
            Logger oldInstance = this.loggerMap.putIfAbsent(tag, newInstance);
            logger = oldInstance == null ? newInstance : oldInstance;
        }
        return logger;
    }

    static String loggerNameToTag(String loggerName) {
        int tokenLength;
        int lastPeriodIndex;
        if (loggerName == null) {
            return ANONYMOUS_TAG;
        }
        int length = loggerName.length();
        if (length <= 23) {
            return loggerName;
        }
        int tagLength = 0;
        int lastTokenIndex = 0;
        StringBuilder tagName = new StringBuilder(26);
        while ((lastPeriodIndex = loggerName.indexOf(46, lastTokenIndex)) != -1) {
            tagName.append(loggerName.charAt(lastTokenIndex));
            tokenLength = lastPeriodIndex - lastTokenIndex;
            if (tokenLength > 1) {
                tagName.append('*');
            }
            tagName.append('.');
            lastTokenIndex = lastPeriodIndex + 1;
            tagLength = tagName.length();
            if (tagLength <= 23) continue;
            return AndroidLoggerFactory.getSimpleName(loggerName);
        }
        tokenLength = length - lastTokenIndex;
        if (tagLength == 0 || tagLength + tokenLength > 23) {
            return AndroidLoggerFactory.getSimpleName(loggerName);
        }
        tagName.append(loggerName, lastTokenIndex, length);
        return tagName.toString();
    }

    private static String getSimpleName(String loggerName) {
        int length = loggerName.length();
        int lastPeriodIndex = loggerName.lastIndexOf(46);
        return lastPeriodIndex != -1 && length - (lastPeriodIndex + 1) <= 23 ? loggerName.substring(lastPeriodIndex + 1) : '*' + loggerName.substring(length - 23 + 1);
    }
}

