/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DateHistogramAggregation
extends BucketAggregation {
    public static final String TYPE = "date_histogram";
    private List<DateHistogram> dateHistograms = new LinkedList<DateHistogram>();

    public DateHistogramAggregation(String name, JsonObject dateHistogramAggregation) {
        super(name, dateHistogramAggregation);
        if (dateHistogramAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && dateHistogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(dateHistogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucket : bucketsSource) {
            Long time = bucket.getAsJsonObject().get(String.valueOf((Object)AggregationField.KEY)).getAsLong();
            String timeAsString = bucket.getAsJsonObject().get(String.valueOf((Object)AggregationField.KEY_AS_STRING)).getAsString();
            Long count = bucket.getAsJsonObject().get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong();
            this.dateHistograms.add(new DateHistogram(bucket.getAsJsonObject(), time, timeAsString, count));
        }
    }

    public List<DateHistogram> getBuckets() {
        return this.dateHistograms;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DateHistogramAggregation rhs = (DateHistogramAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.dateHistograms, rhs.dateHistograms).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dateHistograms).toHashCode();
    }

    public class DateHistogram
    extends HistogramAggregation.Histogram {
        private String timeAsString;

        DateHistogram(JsonObject bucket, Long time, String timeAsString, Long count) {
            super(bucket, time, count);
            this.timeAsString = timeAsString;
        }

        public Long getTime() {
            return this.getKey();
        }

        public String getTimeAsString() {
            return this.timeAsString;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DateHistogram rhs = (DateHistogram)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.timeAsString, rhs.timeAsString).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeAsString).toHashCode();
        }
    }
}

