/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import org.apache.http.impl.conn.LoggingInputStream;
import org.apache.http.impl.conn.LoggingOutputStream;
import org.apache.http.impl.conn.WireHC4;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class LoggingManagedHttpClientConnection
extends DefaultManagedHttpClientConnection {
    private static final String TAG = "HttpClient";
    private static final String HEADER_TAG = "Headers";
    private final WireHC4 wire;

    public LoggingManagedHttpClientConnection(String id, int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(id, buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.wire = new WireHC4(id);
    }

    @Override
    public void close() throws IOException {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)(this.getId() + ": Close connection"));
        }
        super.close();
    }

    @Override
    public void shutdown() throws IOException {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)(this.getId() + ": Shutdown connection"));
        }
        super.shutdown();
    }

    @Override
    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        InputStream in = super.getSocketInputStream(socket);
        if (this.wire.enabled()) {
            in = new LoggingInputStream(in, this.wire);
        }
        return in;
    }

    @Override
    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        OutputStream out = super.getSocketOutputStream(socket);
        if (this.wire.enabled()) {
            out = new LoggingOutputStream(out, this.wire);
        }
        return out;
    }

    @Override
    protected void onResponseReceived(HttpResponse response) {
        if (response != null && Log.isLoggable((String)HEADER_TAG, (int)3)) {
            Header[] headers;
            Log.d((String)HEADER_TAG, (String)(this.getId() + " << " + response.getStatusLine().toString()));
            for (Header header : headers = response.getAllHeaders()) {
                Log.d((String)HEADER_TAG, (String)(this.getId() + " << " + header.toString()));
            }
        }
    }

    @Override
    protected void onRequestSubmitted(HttpRequest request) {
        if (request != null && Log.isLoggable((String)HEADER_TAG, (int)3)) {
            Header[] headers;
            Log.d((String)HEADER_TAG, (String)(this.getId() + " >> " + request.getRequestLine().toString()));
            for (Header header : headers = request.getAllHeaders()) {
                Log.d((String)HEADER_TAG, (String)(this.getId() + " >> " + header.toString()));
            }
        }
    }
}

