/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import io.searchbox.params.SearchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Search
extends AbstractAction<SearchResult> {
    private String query;
    private List<Sort> sortList = new LinkedList<Sort>();

    protected Search(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.sortList = builder.sortList;
        this.setURI(this.buildURI());
    }

    @Override
    public SearchResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        return this.createNewElasticSearchResult(new SearchResult(gson), responseBody, statusCode, reasonPhrase, gson);
    }

    public String getIndex() {
        return this.indexName;
    }

    public String getType() {
        return this.typeName;
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_search";
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(Gson gson) {
        String data;
        if (this.sortList.isEmpty()) {
            data = this.query;
        } else {
            ArrayList<Map<String, Object>> sortMaps = new ArrayList<Map<String, Object>>(this.sortList.size());
            for (Sort sort : this.sortList) {
                sortMaps.add(sort.toMap());
            }
            Map rootJson = gson.fromJson(this.query, Map.class);
            rootJson.put("sort", sortMaps);
            data = gson.toJson(rootJson);
        }
        return data;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.query).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Search rhs = (Search)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.query, rhs.query).append(this.sortList, rhs.sortList).isEquals();
    }

    public static class Builder
    extends AbstractMultiTypeActionBuilder<Search, Builder> {
        private String query;
        private List<Sort> sortList = new LinkedList<Sort>();

        public Builder(String query) {
            this.query = query;
        }

        public Builder setSearchType(SearchType searchType) {
            return (Builder)this.setParameter("search_type", (Object)searchType);
        }

        public Builder addSort(Sort sort) {
            this.sortList.add(sort);
            return this;
        }

        public Builder addSort(Collection<Sort> sorts) {
            this.sortList.addAll(sorts);
            return this;
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }
}

