/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.annotations.JestId;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestResult {
    public static final String ES_METADATA_ID = "es_metadata_id";
    private static final Logger log = LoggerFactory.getLogger(JestResult.class);
    protected JsonObject jsonObject;
    protected String jsonString;
    protected String pathToResult;
    protected int responseCode;
    protected boolean isSucceeded;
    protected String errorMessage;
    protected Gson gson;

    private JestResult() {
    }

    public JestResult(JestResult source) {
        this.jsonObject = source.jsonObject;
        this.jsonString = source.jsonString;
        this.pathToResult = source.pathToResult;
        this.responseCode = source.responseCode;
        this.isSucceeded = source.isSucceeded;
        this.errorMessage = source.errorMessage;
        this.gson = source.gson;
    }

    public JestResult(Gson gson) {
        this.gson = gson;
    }

    public String getPathToResult() {
        return this.pathToResult;
    }

    public void setPathToResult(String pathToResult) {
        this.pathToResult = pathToResult;
    }

    public Object getValue(String key) {
        return this.getJsonMap().get(key);
    }

    public boolean isSucceeded() {
        return this.isSucceeded;
    }

    public void setSucceeded(boolean succeeded) {
        this.isSucceeded = succeeded;
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
        if (jsonObject.get("error") != null) {
            this.errorMessage = jsonObject.get("error").toString();
        }
    }

    @Deprecated
    public Map getJsonMap() {
        return this.gson.fromJson((JsonElement)this.jsonObject, Map.class);
    }

    public void setJsonMap(Map<String, Object> resultMap) {
        String json = this.gson.toJson((Object)resultMap, (Type)((Object)Map.class));
        this.setJsonObject(new JsonParser().parse(json).getAsJsonObject());
    }

    public String getSourceAsString() {
        String[] keys = this.getKeys();
        if (!this.isSucceeded || this.jsonObject == null || keys == null || keys.length == 0 || !this.jsonObject.has(keys[0])) {
            return null;
        }
        JsonElement obj = this.jsonObject.get(keys[0]);
        for (int i = 1; i < keys.length; ++i) {
            obj = ((JsonObject)obj).get(keys[i]);
        }
        return obj.toString();
    }

    public <T> T getSourceAsObject(Class<T> clazz) {
        T sourceAsObject = null;
        List<T> sources = this.getSourceAsObjectList(clazz);
        if (sources.size() > 0) {
            sourceAsObject = sources.get(0);
        }
        return sourceAsObject;
    }

    public <T> List<T> getSourceAsObjectList(Class<T> type) {
        ArrayList<T> objectList = new ArrayList<T>();
        if (this.isSucceeded) {
            for (JsonElement source : this.extractSource()) {
                T obj = this.createSourceObject(source, type);
                if (obj == null) continue;
                objectList.add(obj);
            }
        }
        return objectList;
    }

    protected List<JsonElement> extractSource() {
        ArrayList<JsonElement> sourceList = new ArrayList<JsonElement>();
        if (this.jsonObject != null) {
            String[] keys = this.getKeys();
            if (keys == null) {
                sourceList.add(this.jsonObject);
            } else {
                String sourceKey = keys[keys.length - 1];
                JsonElement obj = this.jsonObject.get(keys[0]);
                if (keys.length > 1) {
                    for (int i = 1; i < keys.length - 1; ++i) {
                        obj = ((JsonObject)obj).get(keys[i]);
                    }
                    if (obj.isJsonObject()) {
                        JsonElement source = obj.getAsJsonObject().get(sourceKey);
                        if (source != null) {
                            sourceList.add(source);
                        }
                    } else if (obj.isJsonArray()) {
                        for (JsonElement element : obj.getAsJsonArray()) {
                            JsonObject currentObj;
                            JsonObject source;
                            if (!(element instanceof JsonObject) || (source = (currentObj = element.getAsJsonObject()).getAsJsonObject(sourceKey)) == null) continue;
                            source.add(ES_METADATA_ID, currentObj.get("_id"));
                            sourceList.add(source);
                        }
                    }
                } else if (obj != null) {
                    JsonElement objId = this.jsonObject.get("_id");
                    if (objId != null && obj.isJsonObject()) {
                        obj.getAsJsonObject().add(ES_METADATA_ID, objId);
                    }
                    sourceList.add(obj);
                }
            }
        }
        return sourceList;
    }

    protected <T> T createSourceObject(JsonElement source, Class<T> type) {
        T obj = null;
        try {
            Field[] fields;
            String json = source.toString();
            obj = this.gson.fromJson(json, type);
            for (Field field : fields = type.getDeclaredFields()) {
                if (!field.isAnnotationPresent(JestId.class)) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value == null) {
                        Class<?> fieldType = field.getType();
                        JsonElement id = ((JsonObject)source).get(ES_METADATA_ID);
                        field.set(obj, this.getAs(id, fieldType));
                    }
                }
                catch (IllegalAccessException e) {
                    log.error("Unhandled exception occurred while getting annotated id from source");
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred while converting source to the object ." + type.getCanonicalName(), e);
        }
        return obj;
    }

    private <T> T getAs(JsonElement id, Class<T> fieldType) throws IllegalAccessException {
        if (id.isJsonNull()) {
            return null;
        }
        if (fieldType.isAssignableFrom(String.class)) {
            return (T)id.getAsString();
        }
        if (fieldType.isAssignableFrom(Number.class)) {
            return (T)id.getAsNumber();
        }
        if (fieldType.isAssignableFrom(BigDecimal.class)) {
            return (T)id.getAsBigDecimal();
        }
        if (fieldType.isAssignableFrom(Double.class)) {
            Double o = id.getAsDouble();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Float.class)) {
            Float o = Float.valueOf(id.getAsFloat());
            return (T)o;
        }
        if (fieldType.isAssignableFrom(BigInteger.class)) {
            return (T)id.getAsBigInteger();
        }
        if (fieldType.isAssignableFrom(Long.class)) {
            Long o = id.getAsLong();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Integer.class)) {
            Integer o = id.getAsInt();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Short.class)) {
            Short o = id.getAsShort();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Character.class)) {
            return (T)Character.valueOf(id.getAsCharacter());
        }
        if (fieldType.isAssignableFrom(Byte.class)) {
            return (T)Byte.valueOf(id.getAsByte());
        }
        if (fieldType.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(id.getAsBoolean());
        }
        throw new RuntimeException("cannot assign " + id + " to " + fieldType);
    }

    protected String[] getKeys() {
        return this.pathToResult == null ? null : this.pathToResult.split("/");
    }
}

