/*
 * Decompiled with CFR 0.152.
 */
package com.searchly.jestdroid;

import com.google.gson.Gson;
import com.searchly.jestdroid.DroidClientConfig;
import com.searchly.jestdroid.DroidReapableConnectionManager;
import com.searchly.jestdroid.JestDroidClient;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.config.idle.IdleConnectionReaper;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestClientFactory {
    static final Logger log = LoggerFactory.getLogger(JestClientFactory.class);
    private DroidClientConfig droidClientConfig;

    public JestClient getObject() {
        JestDroidClient client = new JestDroidClient();
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", this.droidClientConfig.getPlainSocketFactory()).register("https", this.droidClientConfig.getSslSocketFactory()).build();
        if (this.droidClientConfig != null) {
            log.debug("Creating HTTP client based on configuration");
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            client.setRequestCompressionEnabled(this.droidClientConfig.isRequestCompressionEnabled());
            client.setServers(this.droidClientConfig.getServerList());
            boolean isMultiThreaded = this.droidClientConfig.isMultiThreaded();
            if (isMultiThreaded) {
                Integer defaultMaxPerRoute;
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
                Integer maxTotal = this.droidClientConfig.getMaxTotalConnection();
                if (maxTotal != null) {
                    cm.setMaxTotal(maxTotal);
                }
                if ((defaultMaxPerRoute = this.droidClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
                    cm.setDefaultMaxPerRoute(defaultMaxPerRoute);
                }
                Map<HttpRoute, Integer> maxPerRoute = this.droidClientConfig.getMaxTotalConnectionPerRoute();
                for (Map.Entry<HttpRoute, Integer> entry : maxPerRoute.entrySet()) {
                    cm.setMaxPerRoute(entry.getKey(), (int)entry.getValue());
                }
                httpClientBuilder.setConnectionManager(cm);
                log.debug("Multi Threaded http client created");
                if (this.droidClientConfig.getMaxConnectionIdleTime() > 0L) {
                    log.info("Idle connection reaping enabled...");
                    IdleConnectionReaper reaper = new IdleConnectionReaper(this.droidClientConfig, new DroidReapableConnectionManager(cm));
                    client.setIdleConnectionReaper(reaper);
                    reaper.startAsync();
                    reaper.awaitRunning();
                }
            } else {
                log.debug("Default http client is created without multi threaded option");
                httpClientBuilder.setConnectionManager(new BasicHttpClientConnectionManager(registry));
            }
            httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.droidClientConfig.getConnTimeout()).setSocketTimeout(this.droidClientConfig.getReadTimeout()).build()).setDefaultCredentialsProvider(this.droidClientConfig.getCredentialsProvider()).setProxyAuthenticationStrategy(this.droidClientConfig.getProxyAuthenticationStrategy()).setRoutePlanner(this.droidClientConfig.getHttpRoutePlanner());
            Gson gson = this.droidClientConfig.getGson();
            if (gson != null) {
                client.setGson(gson);
            }
            client.setHttpClient(httpClientBuilder.build());
            if (this.droidClientConfig.isDiscoveryEnabled()) {
                log.info("Node Discovery Enabled...");
                NodeChecker nodeChecker = new NodeChecker(client, this.droidClientConfig);
                client.setNodeChecker(nodeChecker);
                nodeChecker.startAsync();
                nodeChecker.awaitRunning();
            } else {
                log.info("Node Discovery Disabled...");
            }
        } else {
            log.debug("There is no configuration to create http client. Going to create simple client with default values");
            client.setHttpClient((HttpClient)new DefaultHttpClient());
            LinkedHashSet<String> servers = new LinkedHashSet<String>();
            servers.add("http://localhost:9200");
            client.setServers(servers);
        }
        return client;
    }

    public void setDroidClientConfig(DroidClientConfig droidClientConfig) {
        this.droidClientConfig = droidClientConfig;
    }
}

