/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import io.searchbox.params.SearchType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search
extends AbstractAction<SearchResult> {
    static final Logger log = LoggerFactory.getLogger(Search.class);
    private String query;
    private List<Sort> sortList = new LinkedList<Sort>();

    private Search(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.sortList = builder.sortList;
        this.setURI(this.buildURI());
    }

    @Override
    public SearchResult createNewElasticSearchResult(String json, int statusCode, String reasonPhrase, Gson gson) {
        return this.createNewElasticSearchResult(new SearchResult(gson), json, statusCode, reasonPhrase, gson);
    }

    public String getIndex() {
        return this.indexName;
    }

    public String getType() {
        return this.typeName;
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_search");
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public Object getData(Gson gson) {
        String data;
        if (this.sortList.size() > 0) {
            StringBuilder sorting = new StringBuilder("\"sort\": [");
            sorting.append(StringUtils.join(this.sortList, ","));
            sorting.append("],");
            data = this.query.replaceFirst("\\{", "\\{" + sorting.toString());
        } else {
            data = this.query;
        }
        return data;
    }

    public static class Builder
    extends AbstractMultiTypeActionBuilder<Search, Builder> {
        private String query;
        private List<Sort> sortList = new LinkedList<Sort>();

        public Builder(String query) {
            this.query = query;
        }

        public Builder setSearchType(SearchType searchType) {
            return (Builder)this.setParameter("search_type", (Object)searchType);
        }

        public Builder addSort(Sort sort) {
            this.sortList.add(sort);
            return this;
        }

        public Builder addSort(Collection<Sort> sorts) {
            this.sortList.addAll(sorts);
            return this;
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }
}

