/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.core.Search;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MultiSearch
extends GenericResultAbstractAction {
    private Collection<Search> searches;

    public MultiSearch(Builder builder) {
        super(builder);
        this.searches = builder.searchList;
        this.setURI(this.buildURI());
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public Object getData(Gson gson) {
        StringBuilder sb = new StringBuilder();
        for (Search search : this.searches) {
            sb.append("{\"index\" : \"").append(search.getIndex());
            if (StringUtils.isNotBlank(search.getType())) {
                sb.append("\", \"type\" : \"").append(search.getType());
            }
            sb.append("\"}\n{\"query\" : ").append(search.getData(gson)).append("}\n");
        }
        return sb.toString();
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_msearch");
        return sb.toString();
    }

    public static class Builder
    extends AbstractAction.Builder<MultiSearch, Builder> {
        private List<Search> searchList = new LinkedList<Search>();

        public Builder(Search search) {
            this.searchList.add(search);
        }

        public Builder(Collection<? extends Search> searches) {
            this.searchList.addAll(searches);
        }

        public Builder addSearch(Search search) {
            this.searchList.add(search);
            return this;
        }

        public Builder addSearch(Collection<? extends Search> searches) {
            this.searchList.addAll(searches);
            return this;
        }

        @Override
        public MultiSearch build() {
            return new MultiSearch(this);
        }
    }
}

