/*
 * Decompiled with CFR 0.152.
 */
package com.searchly.jestdroid;

import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.impl.conn.PoolingClientConnectionManager;
import com.google.gson.Gson;
import com.searchly.jestdroid.DroidClientConfig;
import com.searchly.jestdroid.JestDroidClient;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.discovery.NodeChecker;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestClientFactory {
    static final Logger log = LoggerFactory.getLogger(JestClientFactory.class);
    private DroidClientConfig droidClientConfig;

    public JestClient getObject() {
        JestDroidClient client = new JestDroidClient();
        if (this.droidClientConfig != null) {
            DefaultHttpClient httpclient;
            log.debug("Creating HTTP client based on configuration");
            client.setServers(this.droidClientConfig.getServerList());
            boolean isMultiThreaded = this.droidClientConfig.isMultiThreaded();
            if (isMultiThreaded) {
                Integer defaultMaxPerRoute;
                PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
                Integer maxTotal = this.droidClientConfig.getMaxTotalConnection();
                if (maxTotal != null) {
                    cm.setMaxTotal(maxTotal);
                }
                if ((defaultMaxPerRoute = this.droidClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
                    cm.setDefaultMaxPerRoute(defaultMaxPerRoute);
                }
                Map<HttpRoute, Integer> maxPerRoute = this.droidClientConfig.getMaxTotalConnectionPerRoute();
                for (HttpRoute route : maxPerRoute.keySet()) {
                    cm.setMaxPerRoute(route, (int)maxPerRoute.get(route));
                }
                httpclient = new DefaultHttpClient(cm);
                log.debug("Multi Threaded http client created");
            } else {
                httpclient = new DefaultHttpClient();
                log.debug("Default http client is created without multi threaded option");
            }
            httpclient.getParams().setParameter("http.connection.timeout", this.droidClientConfig.getConnTimeout());
            httpclient.getParams().setParameter("http.socket.timeout", this.droidClientConfig.getReadTimeout());
            Gson gson = this.droidClientConfig.getGson();
            if (gson != null) {
                client.setGson(gson);
            }
            client.setHttpClient(httpclient);
            if (this.droidClientConfig.isDiscoveryEnabled()) {
                log.info("Node Discovery Enabled...");
                NodeChecker nodeChecker = new NodeChecker(this.droidClientConfig, client);
                client.setNodeChecker(nodeChecker);
                nodeChecker.startAsync();
                nodeChecker.awaitRunning();
            } else {
                log.info("Node Discovery Disabled...");
            }
        } else {
            log.debug("There is no configuration to create http client. Going to create simple client with default values");
            client.setHttpClient(new DefaultHttpClient());
            LinkedHashSet<String> servers = new LinkedHashSet<String>();
            servers.add("http://localhost:9200");
            client.setServers(servers);
        }
        return client;
    }

    public Class<?> getObjectType() {
        return JestClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setDroidClientConfig(DroidClientConfig droidClientConfig) {
        this.droidClientConfig = droidClientConfig;
    }
}

