/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.impl.client.cache.AsynchronousValidationRequest;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheConfig;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheKeyGenerator;
import ch.boye.httpclientandroidlib.impl.client.cache.CachingHttpClient;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsynchronousValidator {
    private final CachingHttpClient cachingClient;
    private final ExecutorService executor;
    private final Set<String> queued;
    private final CacheKeyGenerator cacheKeyGenerator;
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    public AsynchronousValidator(CachingHttpClient cachingClient, CacheConfig config) {
        this(cachingClient, new ThreadPoolExecutor(config.getAsynchronousWorkersCore(), config.getAsynchronousWorkersMax(), config.getAsynchronousWorkerIdleLifetimeSecs(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(config.getRevalidationQueueSize())));
    }

    AsynchronousValidator(CachingHttpClient cachingClient, ExecutorService executor) {
        this.cachingClient = cachingClient;
        this.executor = executor;
        this.queued = new HashSet<String>();
        this.cacheKeyGenerator = new CacheKeyGenerator();
    }

    public synchronized void revalidateCacheEntry(HttpHost target, HttpRequest request, HttpContext context, HttpCacheEntry entry) {
        String uri = this.cacheKeyGenerator.getVariantURI(target, request, entry);
        if (!this.queued.contains(uri)) {
            AsynchronousValidationRequest revalidationRequest = new AsynchronousValidationRequest(this, this.cachingClient, target, request, context, entry, uri);
            try {
                this.executor.execute(revalidationRequest);
                this.queued.add(uri);
            }
            catch (RejectedExecutionException ree) {
                this.log.debug("Revalidation for [" + uri + "] not scheduled: " + ree);
            }
        }
    }

    synchronized void markComplete(String identifier) {
        this.queued.remove(identifier);
    }

    Set<String> getScheduledIdentifiers() {
        return Collections.unmodifiableSet(this.queued);
    }

    ExecutorService getExecutor() {
        return this.executor;
    }
}

