/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.androidextra;

import android.util.Log;

public class HttpClientAndroidLog {
    private String logTag;
    private boolean debugEnabled;
    private boolean errorEnabled;
    private boolean traceEnabled;
    private boolean warnEnabled;
    private boolean infoEnabled;

    public HttpClientAndroidLog(Object tag) {
        this.logTag = tag.toString();
        this.debugEnabled = false;
        this.errorEnabled = false;
        this.traceEnabled = false;
        this.warnEnabled = false;
        this.infoEnabled = false;
    }

    public void enableDebug(boolean enable) {
        this.debugEnabled = enable;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            Log.d((String)this.logTag, (String)message.toString());
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            Log.d((String)this.logTag, (String)message.toString(), (Throwable)t);
        }
    }

    public void enableError(boolean enable) {
        this.errorEnabled = enable;
    }

    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            Log.e((String)this.logTag, (String)message.toString());
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            Log.e((String)this.logTag, (String)message.toString(), (Throwable)t);
        }
    }

    public void enableWarn(boolean enable) {
        this.warnEnabled = enable;
    }

    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            Log.w((String)this.logTag, (String)message.toString());
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            Log.w((String)this.logTag, (String)message.toString(), (Throwable)t);
        }
    }

    public void enableInfo(boolean enable) {
        this.infoEnabled = enable;
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            Log.i((String)this.logTag, (String)message.toString());
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            Log.i((String)this.logTag, (String)message.toString(), (Throwable)t);
        }
    }

    public void enableTrace(boolean enable) {
        this.traceEnabled = enable;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            Log.i((String)this.logTag, (String)message.toString());
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            Log.i((String)this.logTag, (String)message.toString(), (Throwable)t);
        }
    }
}

