/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.Range;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DateRangeAggregation
extends BucketAggregation {
    public static final String TYPE = "date_range";
    private List<DateRange> ranges = new LinkedList<DateRange>();

    public DateRangeAggregation(String name, JsonObject dateRangeAggregation) {
        super(name, dateRangeAggregation);
        if (dateRangeAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && dateRangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(dateRangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray buckets) {
        for (JsonElement bucketv : buckets) {
            JsonObject bucket;
            DateRange range = new DateRange(bucket, (bucket = bucketv.getAsJsonObject()).has(String.valueOf((Object)AggregationField.FROM)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.FROM)).getAsDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.TO)).getAsDouble()) : null, bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong(), bucket.has(String.valueOf((Object)AggregationField.FROM_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.FROM_AS_STRING)).getAsString() : null, bucket.has(String.valueOf((Object)AggregationField.TO_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.TO_AS_STRING)).getAsString() : null);
            this.ranges.add(range);
        }
    }

    public List<DateRange> getBuckets() {
        return this.ranges;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateRangeAggregation)) {
            return false;
        }
        DateRangeAggregation rhs = (DateRangeAggregation)o;
        return new EqualsBuilder().append(this.getBuckets(), rhs.getBuckets()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.getBuckets()).toHashCode();
    }

    public class DateRange
    extends Range {
        private String fromAsString;
        private String toAsString;

        public DateRange(JsonObject bucket, Double from, Double to, Long count, String fromString, String toString) {
            super(bucket, from, to, count);
            this.fromAsString = fromString;
            this.toAsString = toString;
        }

        public String getFromAsString() {
            return this.fromAsString;
        }

        public String getToAsString() {
            return this.toAsString;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DateRange)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DateRange rhs = (DateRange)o;
            return new EqualsBuilder().append((Object)this.fromAsString, (Object)rhs.fromAsString).append((Object)this.toAsString, (Object)rhs.toAsString).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.fromAsString).append((Object)this.toAsString).toHashCode();
        }
    }
}

