/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.searchbox.client.JestResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SuggestResult
extends JestResult {
    public SuggestResult(SuggestResult suggestResult) {
        super(suggestResult);
    }

    public SuggestResult(Gson gson) {
        super(gson);
    }

    public List<Suggestion> getSuggestions(String suggestionName) {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        if (this.jsonObject != null && this.jsonObject.has(suggestionName)) {
            for (JsonElement suggestionElement : this.jsonObject.getAsJsonArray(suggestionName)) {
                suggestions.add((Suggestion)this.gson.fromJson(suggestionElement, Suggestion.class));
            }
        }
        return suggestions;
    }

    public class Suggestion {
        public final String text;
        public final Integer offset;
        public final Integer length;
        public final List<Map<String, Object>> options;

        public Suggestion(String text, Integer offset, Integer length, List<Map<String, Object>> options) {
            this.text = text;
            this.offset = offset;
            this.length = length;
            this.options = options;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.text).append((Object)this.offset).append((Object)this.length).append(this.options).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Suggestion rhs = (Suggestion)obj;
            return new EqualsBuilder().append((Object)this.text, (Object)rhs.text).append((Object)this.offset, (Object)rhs.offset).append((Object)this.length, (Object)rhs.length).append(this.options, rhs.options).isEquals();
        }
    }
}

