/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config;

import io.searchbox.client.config.ServerList;
import io.searchbox.client.config.exception.NoServerConfiguredException;
import io.searchbox.client.util.PaddedAtomicInteger;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinServerList
implements ServerList {
    private final Set<String> servers;
    private final String[] serverList;
    private final int wrapPoint;
    private final CircularIncrement incrementer;

    public RoundRobinServerList(Set<String> servers) {
        this(servers, -1, true);
    }

    public RoundRobinServerList(Set<String> servers, boolean strictOrdering) {
        this(servers, -1, strictOrdering);
    }

    public RoundRobinServerList(Set<String> servers, int startAt) {
        this(servers, startAt, true);
    }

    public RoundRobinServerList(Set<String> servers, int startAt, boolean strictOrdering) throws NoServerConfiguredException {
        if (servers.size() == 0) {
            throw new NoServerConfiguredException("No Server is assigned to client to connect");
        }
        this.servers = servers;
        this.wrapPoint = servers.size();
        int i = 0;
        this.serverList = new String[this.wrapPoint];
        for (String elasticSearchServer : servers) {
            this.serverList[i++] = elasticSearchServer.endsWith("/") ? elasticSearchServer.substring(0, elasticSearchServer.length() - 1) : elasticSearchServer;
        }
        int nextPowerOfTwo = RoundRobinServerList.ceilingNextPowerOfTwo(this.wrapPoint);
        this.incrementer = nextPowerOfTwo == this.wrapPoint ? new PowerOfTwoIncrement(nextPowerOfTwo, startAt) : (strictOrdering ? new StrictOrderModulusIncrement(this.wrapPoint, startAt) : new ModulusIncrement(this.wrapPoint, startAt));
    }

    @Override
    public Set getServers() {
        return this.servers;
    }

    @Override
    public String getServer() {
        return this.serverList[this.incrementer.nextVal()];
    }

    public static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    private class StrictOrderModulusIncrement
    implements CircularIncrement {
        private final int mask;
        private final AtomicInteger nextPointer;

        public StrictOrderModulusIncrement(int sizeOfArray, int startPosition) {
            this.nextPointer = new PaddedAtomicInteger(startPosition);
            this.mask = sizeOfArray;
        }

        @Override
        public int nextVal() {
            int nextVal;
            int currentVal;
            do {
                currentVal = this.nextPointer.get();
                nextVal = currentVal + 1;
                if (currentVal != Integer.MAX_VALUE) continue;
                int prev = currentVal % this.mask + 1;
                int n = nextVal = prev > this.mask ? 0 : prev;
            } while (!this.nextPointer.compareAndSet(currentVal, nextVal));
            return nextVal % this.mask;
        }
    }

    private class ModulusIncrement
    implements CircularIncrement {
        private final int mask;
        private final AtomicInteger nextPointer;

        public ModulusIncrement(int sizeOfArray, int startPosition) {
            this.nextPointer = new PaddedAtomicInteger(startPosition);
            this.mask = sizeOfArray;
        }

        @Override
        public int nextVal() {
            return Math.abs(this.nextPointer.incrementAndGet() % this.mask);
        }
    }

    private class PowerOfTwoIncrement
    implements CircularIncrement {
        private final AtomicInteger nextPointer;
        private final int mask;

        public PowerOfTwoIncrement(int sizeOfArray, int startPosition) {
            this.nextPointer = new PaddedAtomicInteger(startPosition);
            this.mask = sizeOfArray - 1;
        }

        @Override
        public int nextVal() {
            return this.nextPointer.incrementAndGet() & this.mask;
        }
    }

    private static interface CircularIncrement {
        public int nextVal();
    }
}

