/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.UriUtils;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import io.rsocket.uri.UriHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class WebsocketUriHandler
implements UriHandler {
    private static final List<String> SCHEME = Arrays.asList("ws", "wss", "http", "https");

    public Optional<ClientTransport> buildClient(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        if (SCHEME.stream().noneMatch(scheme -> scheme.equals(uri.getScheme()))) {
            return Optional.empty();
        }
        return Optional.of(WebsocketClientTransport.create(uri));
    }

    public Optional<ServerTransport> buildServer(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        if (SCHEME.stream().noneMatch(scheme -> scheme.equals(uri.getScheme()))) {
            return Optional.empty();
        }
        int port = UriUtils.isSecure(uri) ? UriUtils.getPort(uri, 443) : UriUtils.getPort(uri, 80);
        return Optional.of(WebsocketServerTransport.create(uri.getHost(), port));
    }
}

