/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaders;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.TransportHeaderAware;
import io.rsocket.transport.netty.UriUtils;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

public final class WebsocketClientTransport
implements ClientTransport,
TransportHeaderAware {
    private static final int DEFAULT_FRAME_SIZE = 65536;
    private static final String DEFAULT_PATH = "/";
    private final HttpClient client;
    private String path;
    private Supplier<Map<String, String>> transportHeaders = Collections::emptyMap;

    private WebsocketClientTransport(HttpClient client, String path) {
        this.client = client;
        this.path = path;
    }

    public static WebsocketClientTransport create(int port) {
        TcpClient client = TcpClient.create().port(port);
        return WebsocketClientTransport.create(client);
    }

    public static WebsocketClientTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        TcpClient client = TcpClient.create().host(bindAddress).port(port);
        return WebsocketClientTransport.create(client);
    }

    public static WebsocketClientTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        TcpClient client = TcpClient.create().addressSupplier(() -> address);
        return WebsocketClientTransport.create(client);
    }

    public static WebsocketClientTransport create(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        TcpClient client = WebsocketClientTransport.createClient(uri);
        return WebsocketClientTransport.create(HttpClient.from((TcpClient)client), uri.getPath());
    }

    public static WebsocketClientTransport create(TcpClient client) {
        Objects.requireNonNull(client, "client must not be null");
        return WebsocketClientTransport.create(HttpClient.from((TcpClient)client), DEFAULT_PATH);
    }

    public static WebsocketClientTransport create(HttpClient client, String path) {
        Objects.requireNonNull(client, "client must not be null");
        Objects.requireNonNull(path, "path must not be null");
        path = path.startsWith(DEFAULT_PATH) ? path : DEFAULT_PATH + path;
        return new WebsocketClientTransport(client, path);
    }

    private static TcpClient createClient(URI uri) {
        if (UriUtils.isSecure(uri)) {
            return TcpClient.create().secure().host(uri.getHost()).port(UriUtils.getPort(uri, 443));
        }
        return TcpClient.create().host(uri.getHost()).port(UriUtils.getPort(uri, 80));
    }

    public Mono<DuplexConnection> connect(int mtu) {
        return ((HttpClient.WebsocketSender)this.client.headers(headers -> this.transportHeaders.get().forEach((arg_0, arg_1) -> ((HttpHeaders)headers).set(arg_0, arg_1))).websocket(0xFFFFFF).uri(this.path)).connect().map(c -> {
            WebsocketDuplexConnection connection = new WebsocketDuplexConnection((Connection)c);
            if (mtu > 0) {
                connection = new FragmentationDuplexConnection((DuplexConnection)connection, ByteBufAllocator.DEFAULT, mtu, false, "client");
            }
            return connection;
        });
    }

    public void setTransportHeaders(Supplier<Map<String, String>> transportHeaders) {
        this.transportHeaders = Objects.requireNonNull(transportHeaders, "transportHeaders must not be null");
    }
}

