/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.netty.handler.codec.http.HttpHeaders;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.TransportHeaderAware;
import io.rsocket.transport.netty.UriUtils;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;

public final class WebsocketClientTransport
implements ClientTransport,
TransportHeaderAware {
    private final HttpClient client;
    private String path;
    private Supplier<Map<String, String>> transportHeaders = Collections::emptyMap;

    private WebsocketClientTransport(HttpClient client, String path) {
        this.client = client;
        this.path = path;
    }

    public static WebsocketClientTransport create(int port) {
        HttpClient httpClient = HttpClient.create((int)port);
        return WebsocketClientTransport.create(httpClient, "/");
    }

    public static WebsocketClientTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        HttpClient httpClient = HttpClient.create((String)bindAddress, (int)port);
        return WebsocketClientTransport.create(httpClient, "/");
    }

    public static WebsocketClientTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        return WebsocketClientTransport.create(address.getHostName(), address.getPort());
    }

    public static WebsocketClientTransport create(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        HttpClient httpClient = WebsocketClientTransport.createClient(uri);
        return WebsocketClientTransport.create(httpClient, uri.getPath());
    }

    public static WebsocketClientTransport create(HttpClient client, String path) {
        Objects.requireNonNull(client, "client must not be null");
        Objects.requireNonNull(path, "path must not be null");
        return new WebsocketClientTransport(client, path);
    }

    public Mono<DuplexConnection> connect() {
        return Mono.create((T sink) -> this.client.ws(this.path, hb -> this.transportHeaders.get().forEach((arg_0, arg_1) -> ((HttpHeaders)hb).set(arg_0, arg_1))).flatMap(response -> response.receiveWebsocket((in, out) -> {
            WebsocketDuplexConnection connection = new WebsocketDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            sink.success((Object)connection);
            return connection.onClose();
        })).doOnError(arg_0 -> ((MonoSink)sink).error(arg_0)).subscribe());
    }

    public void setTransportHeaders(Supplier<Map<String, String>> transportHeaders) {
        this.transportHeaders = Objects.requireNonNull(transportHeaders, "transportHeaders must not be null");
    }

    private static HttpClient createClient(URI uri) {
        if (UriUtils.isSecure(uri)) {
            return HttpClient.create((T options) -> {
                HttpClientOptions.Builder cfr_ignored_0 = (HttpClientOptions.Builder)((HttpClientOptions.Builder)options.sslSupport()).connectAddress(() -> InetSocketAddress.createUnresolved(uri.getHost(), UriUtils.getPort(uri, 443)));
            });
        }
        return HttpClient.create((String)uri.getHost(), (int)UriUtils.getPort(uri, 80));
    }
}

