/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import io.rsocket.frame.FrameHeaderFlyweight;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;

public final class WebsocketDuplexConnection
implements DuplexConnection {
    private final NettyContext context;
    private final NettyInbound in;
    private final NettyOutbound out;

    public WebsocketDuplexConnection(NettyInbound in, NettyOutbound out, NettyContext context) {
        this.in = Objects.requireNonNull(in, "in must not be null");
        this.out = Objects.requireNonNull(out, "out must not be null");
        this.context = Objects.requireNonNull(context, "context must not be null");
    }

    public void dispose() {
        this.context.dispose();
    }

    public boolean isDisposed() {
        return this.context.isDisposed();
    }

    public Mono<Void> onClose() {
        return this.context.onClose();
    }

    public Flux<Frame> receive() {
        return this.in.receive().map(buf -> {
            CompositeByteBuf composite = this.context.channel().alloc().compositeBuffer();
            ByteBuf length = Unpooled.wrappedBuffer((byte[])new byte[3]);
            FrameHeaderFlyweight.encodeLength((ByteBuf)length, (int)0, (int)buf.readableBytes());
            composite.addComponents(true, new ByteBuf[]{length, buf.retain()});
            return Frame.from((ByteBuf)composite);
        });
    }

    public Mono<Void> send(Publisher<Frame> frames) {
        return Flux.from(frames).concatMap(this::sendOne).then();
    }

    public Mono<Void> sendOne(Frame frame) {
        return this.out.sendObject((Object)new BinaryWebSocketFrame(frame.content().skipBytes(3))).then();
    }
}

