/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import io.rsocket.transport.netty.server.CloseableChannel;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public final class WebsocketRouteTransport
implements ServerTransport<Closeable> {
    private final String path;
    private final Consumer<? super HttpServerRoutes> routesBuilder;
    private final HttpServer server;

    public WebsocketRouteTransport(HttpServer server, Consumer<? super HttpServerRoutes> routesBuilder, String path) {
        this.server = Objects.requireNonNull(server, "server must not be null");
        this.routesBuilder = Objects.requireNonNull(routesBuilder, "routesBuilder must not be null");
        this.path = Objects.requireNonNull(path, "path must not be null");
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return this.server.route(routes -> {
            this.routesBuilder.accept((HttpServerRoutes)routes);
            routes.ws(this.path, WebsocketRouteTransport.newHandler(acceptor));
        }).bind().map(CloseableChannel::new);
    }

    public static BiFunction<WebsocketInbound, WebsocketOutbound, Publisher<Void>> newHandler(ServerTransport.ConnectionAcceptor acceptor) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return (in, out) -> {
            WebsocketDuplexConnection connection = new WebsocketDuplexConnection((Connection)in);
            return acceptor.apply((DuplexConnection)connection).then(out.neverComplete());
        };
    }
}

