/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class MicrometerDuplexConnection
implements DuplexConnection {
    private final Counter close;
    private final DuplexConnection delegate;
    private final Counter dispose;
    private final FrameCounters frameCounters;

    MicrometerDuplexConnection(DuplexConnectionInterceptor.Type connectionType, DuplexConnection delegate, MeterRegistry meterRegistry, Tag ... tags) {
        Objects.requireNonNull(connectionType, "connectionType must not be null");
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        Objects.requireNonNull(meterRegistry, "meterRegistry must not be null");
        this.close = meterRegistry.counter("rsocket.duplex.connection.close", (Iterable)Tags.of((Tag[])tags).and("connection.type", connectionType.name()));
        this.dispose = meterRegistry.counter("rsocket.duplex.connection.dispose", (Iterable)Tags.of((Tag[])tags).and("connection.type", connectionType.name()));
        this.frameCounters = new FrameCounters(connectionType, meterRegistry, tags);
    }

    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    public void dispose() {
        this.delegate.dispose();
        this.dispose.increment();
    }

    public Mono<Void> onClose() {
        return this.delegate.onClose().doAfterTerminate(() -> ((Counter)this.close).increment());
    }

    public Flux<ByteBuf> receive() {
        return this.delegate.receive().doOnNext((Consumer)this.frameCounters);
    }

    public Mono<Void> send(Publisher<ByteBuf> frames) {
        Objects.requireNonNull(frames, "frames must not be null");
        return this.delegate.send((Publisher)Flux.from(frames).doOnNext((Consumer)this.frameCounters));
    }

    private static final class FrameCounters
    implements Consumer<ByteBuf> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Counter cancel;
        private final Counter complete;
        private final Counter error;
        private final Counter extension;
        private final Counter keepalive;
        private final Counter lease;
        private final Counter metadataPush;
        private final Counter next;
        private final Counter nextComplete;
        private final Counter payload;
        private final Counter requestChannel;
        private final Counter requestFireAndForget;
        private final Counter requestN;
        private final Counter requestResponse;
        private final Counter requestStream;
        private final Counter resume;
        private final Counter resumeOk;
        private final Counter setup;
        private final Counter unknown;

        private FrameCounters(DuplexConnectionInterceptor.Type connectionType, MeterRegistry meterRegistry, Tag ... tags) {
            this.cancel = FrameCounters.counter(connectionType, meterRegistry, FrameType.CANCEL, tags);
            this.complete = FrameCounters.counter(connectionType, meterRegistry, FrameType.COMPLETE, tags);
            this.error = FrameCounters.counter(connectionType, meterRegistry, FrameType.ERROR, tags);
            this.extension = FrameCounters.counter(connectionType, meterRegistry, FrameType.EXT, tags);
            this.keepalive = FrameCounters.counter(connectionType, meterRegistry, FrameType.KEEPALIVE, tags);
            this.lease = FrameCounters.counter(connectionType, meterRegistry, FrameType.LEASE, tags);
            this.metadataPush = FrameCounters.counter(connectionType, meterRegistry, FrameType.METADATA_PUSH, tags);
            this.next = FrameCounters.counter(connectionType, meterRegistry, FrameType.NEXT, tags);
            this.nextComplete = FrameCounters.counter(connectionType, meterRegistry, FrameType.NEXT_COMPLETE, tags);
            this.payload = FrameCounters.counter(connectionType, meterRegistry, FrameType.PAYLOAD, tags);
            this.requestChannel = FrameCounters.counter(connectionType, meterRegistry, FrameType.REQUEST_CHANNEL, tags);
            this.requestFireAndForget = FrameCounters.counter(connectionType, meterRegistry, FrameType.REQUEST_FNF, tags);
            this.requestN = FrameCounters.counter(connectionType, meterRegistry, FrameType.REQUEST_N, tags);
            this.requestResponse = FrameCounters.counter(connectionType, meterRegistry, FrameType.REQUEST_RESPONSE, tags);
            this.requestStream = FrameCounters.counter(connectionType, meterRegistry, FrameType.REQUEST_STREAM, tags);
            this.resume = FrameCounters.counter(connectionType, meterRegistry, FrameType.RESUME, tags);
            this.resumeOk = FrameCounters.counter(connectionType, meterRegistry, FrameType.RESUME_OK, tags);
            this.setup = FrameCounters.counter(connectionType, meterRegistry, FrameType.SETUP, tags);
            this.unknown = FrameCounters.counter(connectionType, meterRegistry, "UNKNOWN", tags);
        }

        private static Counter counter(DuplexConnectionInterceptor.Type connectionType, MeterRegistry meterRegistry, FrameType frameType, Tag ... tags) {
            return FrameCounters.counter(connectionType, meterRegistry, frameType.name(), tags);
        }

        private static Counter counter(DuplexConnectionInterceptor.Type connectionType, MeterRegistry meterRegistry, String frameType, Tag ... tags) {
            return meterRegistry.counter("rsocket.frame", (Iterable)Tags.of((Tag[])tags).and("connection.type", connectionType.name()).and("frame.type", frameType));
        }

        @Override
        public void accept(ByteBuf frame) {
            FrameType frameType = FrameHeaderCodec.frameType((ByteBuf)frame);
            switch (frameType) {
                case SETUP: {
                    this.setup.increment();
                    break;
                }
                case LEASE: {
                    this.lease.increment();
                    break;
                }
                case KEEPALIVE: {
                    this.keepalive.increment();
                    break;
                }
                case REQUEST_RESPONSE: {
                    this.requestResponse.increment();
                    break;
                }
                case REQUEST_FNF: {
                    this.requestFireAndForget.increment();
                    break;
                }
                case REQUEST_STREAM: {
                    this.requestStream.increment();
                    break;
                }
                case REQUEST_CHANNEL: {
                    this.requestChannel.increment();
                    break;
                }
                case REQUEST_N: {
                    this.requestN.increment();
                    break;
                }
                case CANCEL: {
                    this.cancel.increment();
                    break;
                }
                case PAYLOAD: {
                    this.payload.increment();
                    break;
                }
                case ERROR: {
                    this.error.increment();
                    break;
                }
                case METADATA_PUSH: {
                    this.metadataPush.increment();
                    break;
                }
                case RESUME: {
                    this.resume.increment();
                    break;
                }
                case RESUME_OK: {
                    this.resumeOk.increment();
                    break;
                }
                case NEXT: {
                    this.next.increment();
                    break;
                }
                case COMPLETE: {
                    this.complete.increment();
                    break;
                }
                case NEXT_COMPLETE: {
                    this.nextComplete.increment();
                    break;
                }
                case EXT: {
                    this.extension.increment();
                    break;
                }
                default: {
                    this.logger.debug("Skipping count of unknown frame type: {}", (Object)frameType);
                    this.unknown.increment();
                }
            }
        }
    }
}

