/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.RSocketErrorException;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.resume.ResumableFramesStore;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Sinks;

public class ResumableDuplexConnection
extends Flux<ByteBuf>
implements DuplexConnection,
Subscription {
    static final Logger logger = LoggerFactory.getLogger(ResumableDuplexConnection.class);
    final String tag;
    final ResumableFramesStore resumableFramesStore;
    final UnboundedProcessor savableFramesSender;
    final Disposable framesSaverDisposable;
    final MonoProcessor<Void> onClose;
    final SocketAddress remoteAddress;
    final Sinks.Many<Integer> onConnectionClosedSink;
    CoreSubscriber<? super ByteBuf> receiveSubscriber;
    FrameReceivingSubscriber activeReceivingSubscriber;
    volatile int state;
    static final AtomicIntegerFieldUpdater<ResumableDuplexConnection> STATE = AtomicIntegerFieldUpdater.newUpdater(ResumableDuplexConnection.class, "state");
    volatile DuplexConnection activeConnection;
    static final AtomicReferenceFieldUpdater<ResumableDuplexConnection, DuplexConnection> ACTIVE_CONNECTION = AtomicReferenceFieldUpdater.newUpdater(ResumableDuplexConnection.class, DuplexConnection.class, "activeConnection");
    int connectionIndex = 0;

    public ResumableDuplexConnection(String tag, DuplexConnection initialConnection, ResumableFramesStore resumableFramesStore) {
        this.tag = tag;
        this.onConnectionClosedSink = Sinks.unsafe().many().unicast().onBackpressureBuffer();
        this.resumableFramesStore = resumableFramesStore;
        this.savableFramesSender = new UnboundedProcessor();
        this.framesSaverDisposable = resumableFramesStore.saveFrames((Flux<ByteBuf>)this.savableFramesSender).subscribe();
        this.onClose = MonoProcessor.create();
        this.remoteAddress = initialConnection.remoteAddress();
        ACTIVE_CONNECTION.lazySet(this, initialConnection);
    }

    public boolean connect(DuplexConnection nextConnection) {
        DuplexConnection activeConnection = this.activeConnection;
        if (activeConnection != DisposedConnection.INSTANCE && ACTIVE_CONNECTION.compareAndSet(this, activeConnection, nextConnection)) {
            activeConnection.dispose();
            this.initConnection(nextConnection);
            return true;
        }
        return false;
    }

    void initConnection(DuplexConnection nextConnection) {
        logger.debug("Tag {}. Initializing connection {}", (Object)this.tag, (Object)nextConnection);
        int currentConnectionIndex = this.connectionIndex;
        FrameReceivingSubscriber frameReceivingSubscriber = new FrameReceivingSubscriber(this.tag, this.resumableFramesStore, this.receiveSubscriber);
        this.connectionIndex = currentConnectionIndex + 1;
        this.activeReceivingSubscriber = frameReceivingSubscriber;
        Disposable disposable = this.resumableFramesStore.resumeStream().subscribe(f -> nextConnection.sendFrame(FrameHeaderCodec.streamId(f), (ByteBuf)f));
        nextConnection.receive().subscribe((CoreSubscriber)frameReceivingSubscriber);
        nextConnection.onClose().doFinally(__ -> {
            frameReceivingSubscriber.dispose();
            disposable.dispose();
            Sinks.EmitResult result = this.onConnectionClosedSink.tryEmitNext((Object)currentConnectionIndex);
            if (result.equals((Object)Sinks.EmitResult.OK)) {
                logger.error("Failed to notify session of closed connection: {}", (Object)result);
            }
        }).subscribe();
    }

    public void disconnect() {
        DuplexConnection activeConnection = this.activeConnection;
        if (activeConnection != DisposedConnection.INSTANCE) {
            activeConnection.dispose();
        }
    }

    @Override
    public void sendFrame(int streamId, ByteBuf frame) {
        if (streamId == 0) {
            this.savableFramesSender.onNextPrioritized(frame);
        } else {
            this.savableFramesSender.onNext(frame);
        }
    }

    Flux<Integer> onActiveConnectionClosed() {
        return this.onConnectionClosedSink.asFlux();
    }

    @Override
    public void sendErrorAndClose(RSocketErrorException rSocketErrorException) {
        DuplexConnection activeConnection = ACTIVE_CONNECTION.getAndSet(this, DisposedConnection.INSTANCE);
        if (activeConnection == DisposedConnection.INSTANCE) {
            return;
        }
        activeConnection.sendErrorAndClose(rSocketErrorException);
        activeConnection.onClose().subscribe(null, t -> {
            this.framesSaverDisposable.dispose();
            this.savableFramesSender.dispose();
            this.onConnectionClosedSink.tryEmitComplete();
            this.onClose.onError(t);
        }, () -> {
            this.framesSaverDisposable.dispose();
            this.savableFramesSender.dispose();
            this.onConnectionClosedSink.tryEmitComplete();
            Throwable cause = rSocketErrorException.getCause();
            if (cause == null) {
                this.onClose.onComplete();
            } else {
                this.onClose.onError(cause);
            }
        });
    }

    @Override
    public Flux<ByteBuf> receive() {
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.activeConnection.alloc();
    }

    @Override
    public Mono<Void> onClose() {
        return this.onClose;
    }

    public void dispose() {
        DuplexConnection activeConnection = ACTIVE_CONNECTION.getAndSet(this, DisposedConnection.INSTANCE);
        if (activeConnection == DisposedConnection.INSTANCE) {
            return;
        }
        if (activeConnection != null) {
            activeConnection.dispose();
        }
        this.framesSaverDisposable.dispose();
        this.activeReceivingSubscriber.dispose();
        this.savableFramesSender.dispose();
        this.onConnectionClosedSink.tryEmitComplete();
        this.onClose.onComplete();
    }

    public boolean isDisposed() {
        return this.onClose.isDisposed();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public void request(long n) {
        if (this.state == 1 && STATE.compareAndSet(this, 1, 2)) {
            this.initConnection(this.activeConnection);
        }
    }

    public void cancel() {
        this.dispose();
    }

    public void subscribe(CoreSubscriber<? super ByteBuf> receiverSubscriber) {
        if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
            this.receiveSubscriber = receiverSubscriber;
            receiverSubscriber.onSubscribe((Subscription)this);
        }
    }

    static boolean isResumableFrame(ByteBuf frame) {
        return FrameHeaderCodec.streamId(frame) != 0;
    }

    private static final class FrameReceivingSubscriber
    implements CoreSubscriber<ByteBuf>,
    Disposable {
        final ResumableFramesStore resumableFramesStore;
        final CoreSubscriber<? super ByteBuf> actual;
        final String tag;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<FrameReceivingSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(FrameReceivingSubscriber.class, Subscription.class, "s");
        boolean cancelled;

        private FrameReceivingSubscriber(String tag, ResumableFramesStore store, CoreSubscriber<? super ByteBuf> actual) {
            this.tag = tag;
            this.resumableFramesStore = store;
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, (Object)this, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(ByteBuf frame) {
            if (this.cancelled || this.s == Operators.cancelledSubscription()) {
                return;
            }
            if (ResumableDuplexConnection.isResumableFrame(frame)) {
                if (this.resumableFramesStore.resumableFrameReceived(frame)) {
                    this.actual.onNext((Object)frame);
                }
                return;
            }
            this.actual.onNext((Object)frame);
        }

        public void onError(Throwable t) {
            Operators.set(S, (Object)this, (Subscription)Operators.cancelledSubscription());
        }

        public void onComplete() {
            Operators.set(S, (Object)this, (Subscription)Operators.cancelledSubscription());
        }

        public void dispose() {
            this.cancelled = true;
            Operators.terminate(S, (Object)this);
        }

        public boolean isDisposed() {
            return this.cancelled || this.s == Operators.cancelledSubscription();
        }
    }

    private static final class DisposedConnection
    implements DuplexConnection {
        static final DisposedConnection INSTANCE = new DisposedConnection();

        private DisposedConnection() {
        }

        public void dispose() {
        }

        @Override
        public Mono<Void> onClose() {
            return Mono.never();
        }

        @Override
        public void sendFrame(int streamId, ByteBuf frame) {
        }

        @Override
        public Flux<ByteBuf> receive() {
            return Flux.never();
        }

        @Override
        public void sendErrorAndClose(RSocketErrorException e) {
        }

        @Override
        public ByteBufAllocator alloc() {
            return ByteBufAllocator.DEFAULT;
        }

        @Override
        public SocketAddress remoteAddress() {
            return null;
        }
    }
}

