/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.RSocket;
import io.rsocket.loadbalance.LoadbalanceStrategy;
import io.rsocket.loadbalance.Stats;
import io.rsocket.loadbalance.WeightedRSocket;
import java.util.List;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import reactor.util.annotation.Nullable;

public class WeightedLoadbalanceStrategy
implements LoadbalanceStrategy {
    private static final double EXP_FACTOR = 4.0;
    private static final int EFFORT = 5;
    final int effort;
    final SplittableRandom splittableRandom;

    public WeightedLoadbalanceStrategy() {
        this(5);
    }

    public WeightedLoadbalanceStrategy(int effort) {
        this(effort, new SplittableRandom(System.nanoTime()));
    }

    public WeightedLoadbalanceStrategy(int effort, SplittableRandom splittableRandom) {
        this.effort = effort;
        this.splittableRandom = splittableRandom;
    }

    @Override
    public RSocket select(List<RSocket> sockets) {
        WeightedRSocket weightedRSocket;
        int effort = this.effort;
        int size = sockets.size();
        switch (size) {
            case 1: {
                weightedRSocket = (WeightedRSocket)sockets.get(0);
                break;
            }
            case 2: {
                WeightedRSocket rsc1 = (WeightedRSocket)sockets.get(0);
                WeightedRSocket rsc2 = (WeightedRSocket)sockets.get(1);
                double w1 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc1);
                double w2 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc2);
                if (w1 < w2) {
                    weightedRSocket = rsc2;
                    break;
                }
                weightedRSocket = rsc1;
                break;
            }
            default: {
                double w2;
                double w1;
                WeightedRSocket rsc1 = null;
                WeightedRSocket rsc2 = null;
                for (int i = 0; i < effort; ++i) {
                    int i1 = ThreadLocalRandom.current().nextInt(size);
                    int i2 = ThreadLocalRandom.current().nextInt(size - 1);
                    if (i2 >= i1) {
                        ++i2;
                    }
                    rsc1 = (WeightedRSocket)sockets.get(i1);
                    rsc2 = (WeightedRSocket)sockets.get(i2);
                    if (rsc1.availability() > 0.0 && rsc2.availability() > 0.0) break;
                }
                weightedRSocket = (w1 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc1)) < (w2 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc2)) ? rsc2 : rsc1;
            }
        }
        return weightedRSocket;
    }

    private static double algorithmicWeight(@Nullable WeightedRSocket weightedRSocket) {
        if (weightedRSocket == null || weightedRSocket.isDisposed() || weightedRSocket.availability() == 0.0) {
            return 0.0;
        }
        Stats stats = weightedRSocket.stats();
        int pending = stats.pending();
        double latency = stats.predictedLatency();
        double low = stats.lowerQuantileLatency();
        double high = Math.max(stats.higherQuantileLatency(), low * 1.001);
        double bandWidth = Math.max(high - low, 1.0);
        if (latency < low) {
            latency /= WeightedLoadbalanceStrategy.calculateFactor(low, latency, bandWidth);
        } else if (latency > high) {
            latency *= WeightedLoadbalanceStrategy.calculateFactor(latency, high, bandWidth);
        }
        return weightedRSocket.availability() * 1.0 / (1.0 + latency * (double)(pending + 1));
    }

    private static double calculateFactor(double u, double l, double bandWidth) {
        double alpha = (u - l) / bandWidth;
        return Math.pow(1.0 + alpha, 4.0);
    }
}

