/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.Availability;
import io.rsocket.lease.LeaseImpl;
import reactor.util.annotation.Nullable;

public interface Lease
extends Availability {
    public static Lease create(int timeToLiveMillis, int numberOfRequests, @Nullable ByteBuf metadata) {
        return LeaseImpl.create(timeToLiveMillis, numberOfRequests, metadata);
    }

    public static Lease create(int timeToLiveMillis, int numberOfRequests) {
        return Lease.create(timeToLiveMillis, numberOfRequests, Unpooled.EMPTY_BUFFER);
    }

    public int getAllowedRequests();

    default public int getStartingAllowedRequests() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getTimeToLiveMillis();

    default public int getRemainingTimeToLiveMillis(long now) {
        return this.isEmpty() ? 0 : (int)Math.max(0L, this.expiry() - now);
    }

    public long expiry();

    public ByteBuf getMetadata();

    default public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    default public boolean isExpired(long now) {
        return now > this.expiry();
    }

    default public boolean isValid() {
        return !this.isExpired() && this.getAllowedRequests() > 0;
    }

    default public boolean isEmpty() {
        return this.getAllowedRequests() == 0 && this.getTimeToLiveMillis() == 0;
    }
}

