/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata.security;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public enum WellKnownAuthType {
    UNPARSEABLE_AUTH_TYPE("UNPARSEABLE_AUTH_TYPE_DO_NOT_USE", -2),
    UNKNOWN_RESERVED_AUTH_TYPE("UNKNOWN_YET_RESERVED_DO_NOT_USE", -1),
    SIMPLE("simple", 0),
    BEARER("bearer", 1);

    static final WellKnownAuthType[] TYPES_BY_AUTH_ID;
    static final Map<String, WellKnownAuthType> TYPES_BY_AUTH_STRING;
    private final byte identifier;
    private final String str;

    private WellKnownAuthType(String str, byte identifier) {
        this.str = str;
        this.identifier = identifier;
    }

    public static WellKnownAuthType fromIdentifier(int id) {
        if (id < 0 || id > 127) {
            return UNPARSEABLE_AUTH_TYPE;
        }
        return TYPES_BY_AUTH_ID[id];
    }

    public static WellKnownAuthType fromString(String authType) {
        if (authType == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (authType.equals(WellKnownAuthType.UNKNOWN_RESERVED_AUTH_TYPE.str)) {
            return UNPARSEABLE_AUTH_TYPE;
        }
        return TYPES_BY_AUTH_STRING.getOrDefault(authType, UNPARSEABLE_AUTH_TYPE);
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    public String getString() {
        return this.str;
    }

    public String toString() {
        return this.str;
    }

    static {
        TYPES_BY_AUTH_ID = new WellKnownAuthType[128];
        Arrays.fill((Object[])TYPES_BY_AUTH_ID, (Object)UNKNOWN_RESERVED_AUTH_TYPE);
        TYPES_BY_AUTH_STRING = new LinkedHashMap<String, WellKnownAuthType>(128);
        for (WellKnownAuthType value : WellKnownAuthType.values()) {
            if (value.getIdentifier() < 0) continue;
            WellKnownAuthType.TYPES_BY_AUTH_ID[value.getIdentifier()] = value;
            TYPES_BY_AUTH_STRING.put(value.getString(), value);
        }
    }
}

