/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.Payload;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.RequestFlyweight;

public class RequestStreamFrameFlyweight {
    private static final RequestFlyweight FLYWEIGHT = new RequestFlyweight(FrameType.REQUEST_STREAM);

    private RequestStreamFrameFlyweight() {
    }

    public static ByteBuf encodeReleasingPayload(ByteBufAllocator allocator, int streamId, long initialRequestN, Payload payload) {
        ByteBuf data;
        boolean hasMetadata = payload.hasMetadata();
        ByteBuf metadata = hasMetadata ? payload.metadata().retain() : null;
        try {
            data = payload.data().retain();
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        try {
            payload.release();
        }
        catch (IllegalReferenceCountException e) {
            data.release();
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        return RequestStreamFrameFlyweight.encode(allocator, streamId, false, initialRequestN, metadata, data);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, int streamId, boolean fragmentFollows, long initialRequestN, ByteBuf metadata, ByteBuf data) {
        if (initialRequestN < 1L) {
            throw new IllegalArgumentException("request n is less than 1");
        }
        int reqN = initialRequestN > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)initialRequestN;
        return FLYWEIGHT.encode(allocator, streamId, fragmentFollows, false, false, reqN, metadata, data);
    }

    public static ByteBuf data(ByteBuf byteBuf) {
        return FLYWEIGHT.dataWithRequestN(byteBuf);
    }

    public static ByteBuf metadata(ByteBuf byteBuf) {
        return FLYWEIGHT.metadataWithRequestN(byteBuf);
    }

    public static long initialRequestN(ByteBuf byteBuf) {
        int requestN = FLYWEIGHT.initialRequestN(byteBuf);
        return requestN == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)requestN;
    }
}

