/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum WellKnownMimeType {
    UNPARSEABLE_MIME_TYPE("UNPARSEABLE_MIME_TYPE_DO_NOT_USE", -2),
    UNKNOWN_RESERVED_MIME_TYPE("UNKNOWN_YET_RESERVED_DO_NOT_USE", -1),
    APPLICATION_AVRO("application/avro", 0),
    APPLICATION_CBOR("application/cbor", 1),
    APPLICATION_GRAPHQL("application/graphql", 2),
    APPLICATION_GZIP("application/gzip", 3),
    APPLICATION_JAVASCRIPT("application/javascript", 4),
    APPLICATION_JSON("application/json", 5),
    APPLICATION_OCTET_STREAM("application/octet-stream", 6),
    APPLICATION_PDF("application/pdf", 7),
    APPLICATION_THRIFT("application/vnd.apache.thrift.binary", 8),
    APPLICATION_PROTOBUF("application/vnd.google.protobuf", 9),
    APPLICATION_XML("application/xml", 10),
    APPLICATION_ZIP("application/zip", 11),
    AUDIO_AAC("audio/aac", 12),
    AUDIO_MP3("audio/mp3", 13),
    AUDIO_MP4("audio/mp4", 14),
    AUDIO_MPEG3("audio/mpeg3", 15),
    AUDIO_MPEG("audio/mpeg", 16),
    AUDIO_OGG("audio/ogg", 17),
    AUDIO_OPUS("audio/opus", 18),
    AUDIO_VORBIS("audio/vorbis", 19),
    IMAGE_BMP("image/bmp", 20),
    IMAGE_GIG("image/gif", 21),
    IMAGE_HEIC_SEQUENCE("image/heic-sequence", 22),
    IMAGE_HEIC("image/heic", 23),
    IMAGE_HEIF_SEQUENCE("image/heif-sequence", 24),
    IMAGE_HEIF("image/heif", 25),
    IMAGE_JPEG("image/jpeg", 26),
    IMAGE_PNG("image/png", 27),
    IMAGE_TIFF("image/tiff", 28),
    MULTIPART_MIXED("multipart/mixed", 29),
    TEXT_CSS("text/css", 30),
    TEXT_CSV("text/csv", 31),
    TEXT_HTML("text/html", 32),
    TEXT_PLAIN("text/plain", 33),
    TEXT_XML("text/xml", 34),
    VIDEO_H264("video/H264", 35),
    VIDEO_H265("video/H265", 36),
    VIDEO_VP8("video/VP8", 37),
    APPLICATION_HESSIAN("application/x-hessian", 38),
    APPLICATION_JAVA_OBJECT("application/x-java-object", 39),
    APPLICATION_CLOUDEVENTS_JSON("application/cloudevents+json", 40),
    MESSAGE_RSOCKET_TRACING_ZIPKIN("message/x.rsocket.tracing-zipkin.v0", 125),
    MESSAGE_RSOCKET_ROUTING("message/x.rsocket.routing.v0", 126),
    MESSAGE_RSOCKET_COMPOSITE_METADATA("message/x.rsocket.composite-metadata.v0", 127);

    static final WellKnownMimeType[] TYPES_BY_MIME_ID;
    static final Map<String, WellKnownMimeType> TYPES_BY_MIME_STRING;
    private final byte identifier;
    private final String str;

    private WellKnownMimeType(String str, byte identifier) {
        this.str = str;
        this.identifier = identifier;
    }

    public static WellKnownMimeType fromIdentifier(int id) {
        if (id < 0 || id > 127) {
            return UNPARSEABLE_MIME_TYPE;
        }
        return TYPES_BY_MIME_ID[id];
    }

    public static WellKnownMimeType fromString(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (mimeType.equals(WellKnownMimeType.UNKNOWN_RESERVED_MIME_TYPE.str)) {
            return UNPARSEABLE_MIME_TYPE;
        }
        return TYPES_BY_MIME_STRING.getOrDefault(mimeType, UNPARSEABLE_MIME_TYPE);
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    public String getString() {
        return this.str;
    }

    public String toString() {
        return this.str;
    }

    static {
        TYPES_BY_MIME_ID = new WellKnownMimeType[128];
        Arrays.fill((Object[])TYPES_BY_MIME_ID, (Object)UNKNOWN_RESERVED_MIME_TYPE);
        TYPES_BY_MIME_STRING = new HashMap<String, WellKnownMimeType>(128);
        for (WellKnownMimeType value : WellKnownMimeType.values()) {
            if (value.getIdentifier() < 0) continue;
            WellKnownMimeType.TYPES_BY_MIME_ID[value.getIdentifier()] = value;
            TYPES_BY_MIME_STRING.put(value.getString(), value);
        }
    }
}

