/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.rsocket.DuplexConnection;
import io.rsocket.keepalive.KeepAliveHandler;
import io.rsocket.resume.ClientRSocketSession;
import io.rsocket.resume.ResumableDuplexConnection;
import io.rsocket.resume.ResumableFramesStore;
import io.rsocket.resume.ResumeStrategy;
import java.time.Duration;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public interface ClientSetup {
    public DuplexConnection connection();

    public KeepAliveHandler keepAliveHandler();

    public ByteBuf resumeToken();

    public static class ResumableClientSetup
    implements ClientSetup {
        private final ByteBuf resumeToken;
        private final ResumableDuplexConnection duplexConnection;
        private final KeepAliveHandler.ResumableKeepAliveHandler keepAliveHandler;

        public ResumableClientSetup(ByteBufAllocator allocator, DuplexConnection connection, Mono<DuplexConnection> newConnectionFactory, ByteBuf resumeToken, ResumableFramesStore resumableFramesStore, Duration resumeSessionDuration, Duration resumeStreamTimeout, Supplier<ResumeStrategy> resumeStrategySupplier, boolean cleanupStoreOnKeepAlive) {
            ClientRSocketSession rSocketSession = new ClientRSocketSession(connection, allocator, resumeSessionDuration, resumeStrategySupplier, resumableFramesStore, resumeStreamTimeout, cleanupStoreOnKeepAlive).continueWith(newConnectionFactory).resumeToken(resumeToken);
            this.duplexConnection = rSocketSession.resumableConnection();
            this.keepAliveHandler = new KeepAliveHandler.ResumableKeepAliveHandler(this.duplexConnection);
            this.resumeToken = resumeToken;
        }

        @Override
        public DuplexConnection connection() {
            return this.duplexConnection;
        }

        @Override
        public KeepAliveHandler keepAliveHandler() {
            return this.keepAliveHandler;
        }

        @Override
        public ByteBuf resumeToken() {
            return this.resumeToken;
        }
    }

    public static class DefaultClientSetup
    implements ClientSetup {
        private final DuplexConnection connection;

        public DefaultClientSetup(DuplexConnection connection) {
            this.connection = connection;
        }

        @Override
        public DuplexConnection connection() {
            return this.connection;
        }

        @Override
        public KeepAliveHandler keepAliveHandler() {
            return new KeepAliveHandler.DefaultKeepAliveHandler(this.connection);
        }

        @Override
        public ByteBuf resumeToken() {
            return Unpooled.EMPTY_BUFFER;
        }
    }
}

