/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.buffer.TupleByteBuf;

public class FrameLengthFlyweight {
    public static final int FRAME_LENGTH_MASK = 0xFFFFFF;
    public static final int FRAME_LENGTH_SIZE = 3;

    private FrameLengthFlyweight() {
    }

    private static void encodeLength(ByteBuf byteBuf, int length) {
        if ((length & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Length is larger than 24 bits");
        }
        byteBuf.writeByte(length >> 16);
        byteBuf.writeByte(length >> 8);
        byteBuf.writeByte(length);
    }

    private static int decodeLength(ByteBuf byteBuf) {
        int length = (byteBuf.readByte() & 0xFF) << 16;
        length |= (byteBuf.readByte() & 0xFF) << 8;
        return length |= byteBuf.readByte() & 0xFF;
    }

    public static ByteBuf encode(ByteBufAllocator allocator, int length, ByteBuf frame) {
        ByteBuf buffer = allocator.buffer();
        FrameLengthFlyweight.encodeLength(buffer, length);
        return TupleByteBuf.of(allocator, buffer, frame);
    }

    public static int length(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int length = FrameLengthFlyweight.decodeLength(byteBuf);
        byteBuf.resetReaderIndex();
        return length;
    }

    public static ByteBuf frame(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(3);
        ByteBuf slice = byteBuf.slice();
        byteBuf.resetReaderIndex();
        return slice;
    }
}

