/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

public class LimitableRequestPublisher<T>
extends Flux<T>
implements Subscription {
    private static final int NOT_CANCELED_STATE = 0;
    private static final int CANCELED_STATE = 1;
    private final Publisher<T> source;
    private volatile int canceled;
    private static final AtomicIntegerFieldUpdater<LimitableRequestPublisher> CANCELED = AtomicIntegerFieldUpdater.newUpdater(LimitableRequestPublisher.class, "canceled");
    private final long prefetch;
    private long internalRequested;
    private long externalRequested;
    private boolean subscribed;
    @Nullable
    private Subscription internalSubscription;

    private LimitableRequestPublisher(Publisher<T> source, long prefetch) {
        this.source = source;
        this.prefetch = prefetch;
    }

    public static <T> LimitableRequestPublisher<T> wrap(Publisher<T> source, long prefetch) {
        return new LimitableRequestPublisher<T>(source, prefetch);
    }

    public static <T> LimitableRequestPublisher<T> wrap(Publisher<T> source) {
        return LimitableRequestPublisher.wrap(source, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(CoreSubscriber<? super T> destination) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            if (this.subscribed) {
                throw new IllegalStateException("only one subscriber at a time");
            }
            this.subscribed = true;
        }
        InnerOperator s = new InnerOperator((Subscriber)destination);
        destination.onSubscribe((Subscription)s);
        this.source.subscribe((Subscriber)s);
        this.increaseInternalLimit(this.prefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseInternalLimit(long n) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            long requested = this.internalRequested;
            if (requested == Long.MAX_VALUE) {
                return;
            }
            this.internalRequested = Operators.addCap((long)n, (long)requested);
        }
        this.requestN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            long requested = this.externalRequested;
            if (requested == Long.MAX_VALUE) {
                return;
            }
            this.externalRequested = Operators.addCap((long)n, (long)requested);
        }
        this.requestN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestN() {
        long r;
        Subscription s;
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            s = this.internalSubscription;
            if (s == null) {
                return;
            }
            long er = this.externalRequested;
            long ir = this.internalRequested;
            if (er != Long.MAX_VALUE || ir != Long.MAX_VALUE) {
                r = Math.min(ir, er);
                if (er != Long.MAX_VALUE) {
                    this.externalRequested -= r;
                }
                if (ir != Long.MAX_VALUE) {
                    this.internalRequested -= r;
                }
            } else {
                r = Long.MAX_VALUE;
            }
        }
        if (r > 0L) {
            s.request(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.isCanceled() && CANCELED.compareAndSet(this, 0, 1)) {
            Subscription s;
            LimitableRequestPublisher limitableRequestPublisher = this;
            synchronized (limitableRequestPublisher) {
                s = this.internalSubscription;
                this.internalSubscription = null;
                this.subscribed = false;
            }
            if (s != null) {
                s.cancel();
            }
        }
    }

    private boolean isCanceled() {
        return this.canceled == 1;
    }

    private class InnerOperator
    implements CoreSubscriber<T>,
    Subscription {
        final Subscriber<? super T> destination;

        private InnerOperator(Subscriber<? super T> destination) {
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(Subscription s) {
            LimitableRequestPublisher limitableRequestPublisher = LimitableRequestPublisher.this;
            synchronized (limitableRequestPublisher) {
                LimitableRequestPublisher.this.internalSubscription = s;
                if (LimitableRequestPublisher.this.isCanceled()) {
                    s.cancel();
                    LimitableRequestPublisher.this.subscribed = false;
                    LimitableRequestPublisher.this.internalSubscription = null;
                }
            }
            LimitableRequestPublisher.this.requestN();
        }

        public void onNext(T t) {
            try {
                this.destination.onNext(t);
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }

        public void onError(Throwable t) {
            this.destination.onError(t);
        }

        public void onComplete() {
            this.destination.onComplete();
        }

        public void request(long n) {
        }

        public void cancel() {
            LimitableRequestPublisher.this.cancel();
        }
    }
}

