/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.buffer.AbstractTupleByteBuf;
import io.rsocket.buffer.BufferUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.Charset;

class Tuple2ByteBuf
extends AbstractTupleByteBuf {
    private static final long ONE_MASK = 0x100000000L;
    private static final long TWO_MASK = 0x200000000L;
    private static final long MASK = 0x700000000L;
    private final ByteBuf one;
    private final ByteBuf two;
    private final int oneReadIndex;
    private final int twoReadIndex;
    private final int oneReadableBytes;
    private final int twoReadableBytes;
    private final int twoRelativeIndex;
    private boolean freed;

    Tuple2ByteBuf(ByteBufAllocator allocator, ByteBuf one, ByteBuf two) {
        super(allocator, one.readableBytes() + two.readableBytes());
        this.one = one;
        this.two = two;
        this.oneReadIndex = one.readerIndex();
        this.twoReadIndex = two.readerIndex();
        this.oneReadableBytes = one.readableBytes();
        this.twoReadableBytes = two.readableBytes();
        this.twoRelativeIndex = this.oneReadableBytes;
        this.freed = false;
    }

    @Override
    long calculateRelativeIndex(int index) {
        long mask;
        long relativeIndex;
        this.checkIndex(index, 0);
        if (index >= this.twoRelativeIndex) {
            relativeIndex = this.twoReadIndex + (index - this.oneReadableBytes);
            mask = 0x200000000L;
        } else {
            relativeIndex = this.oneReadIndex + index;
            mask = 0x100000000L;
        }
        return relativeIndex | mask;
    }

    @Override
    ByteBuf getPart(int index) {
        long ri = this.calculateRelativeIndex(index);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                return this.one;
            }
            case 2: {
                return this.two;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isDirect() {
        return this.one.isDirect() && this.two.isDirect();
    }

    public int nioBufferCount() {
        return this.one.nioBufferCount() + this.two.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        ByteBuffer[] oneBuffers = this.one.nioBuffers();
        ByteBuffer[] twoBuffers = this.two.nioBuffers();
        ByteBuffer merged = BufferUtil.allocateDirectAligned(this.capacity, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT).order(this.order());
        for (ByteBuffer b : oneBuffers) {
            merged.put(b);
        }
        for (ByteBuffer b : twoBuffers) {
            merged.put(b);
        }
        merged.flip();
        return merged;
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        if (length == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                ByteBuffer[] oneBuffer = this.one.nioBuffers(index, l);
                if ((length -= l) != 0) {
                    ByteBuffer[] twoBuffer = this.two.nioBuffers(this.twoReadIndex, length);
                    ByteBuffer[] results = new ByteBuffer[oneBuffer.length + twoBuffer.length];
                    System.arraycopy(oneBuffer, 0, results, 0, oneBuffer.length);
                    System.arraycopy(twoBuffer, 0, results, oneBuffer.length, twoBuffer.length);
                    return results;
                }
                return oneBuffer;
            }
            case 2: {
                return this.two.nioBuffers(index, length);
            }
        }
        throw new IllegalStateException();
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                this.one.getBytes(index, dst, dstIndex, l);
                dstIndex += l;
                if ((length -= l) == 0) break;
                this.two.getBytes(this.twoReadIndex, dst, dstIndex, length);
                break;
            }
            case 2: {
                this.two.getBytes(index, dst, dstIndex, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        ByteBuf dstBuf = Unpooled.wrappedBuffer((byte[])dst);
        int min = Math.min(dst.length, this.capacity);
        return this.getBytes(0, dstBuf, index, min);
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        ByteBuf dstBuf = Unpooled.wrappedBuffer((ByteBuffer)dst);
        int min = Math.min(dst.limit(), this.capacity);
        return this.getBytes(0, dstBuf, index, min);
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                this.one.getBytes(index, out, l);
                if ((length -= l) == 0) break;
                this.two.getBytes(this.twoReadIndex, out, length);
                break;
            }
            case 2: {
                this.two.getBytes(index, out, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        int read = 0;
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                read += this.one.getBytes(index, out, l);
                if ((length -= l) == 0) break;
                read += this.two.getBytes(this.twoReadIndex, out, length);
                break;
            }
            case 2: {
                read += this.two.getBytes(index, out, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return read;
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        this.checkIndex(index, length);
        int read = 0;
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                read += this.one.getBytes(index, out, position, l);
                position += (long)l;
                if ((length -= l) == 0) break;
                read += this.two.getBytes(this.twoReadIndex, out, position, length);
                break;
            }
            case 2: {
                read += this.two.getBytes(index, out, position, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return read;
    }

    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        ByteBuf buffer = this.allocator.buffer(length);
        if (index == 0 && length == this.capacity) {
            buffer.writeBytes(this.one, this.oneReadIndex, this.oneReadableBytes);
            buffer.writeBytes(this.two, this.twoReadIndex, this.twoReadableBytes);
            return buffer;
        }
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                buffer.writeBytes(this.one, index, l);
                if ((length -= l) != 0) {
                    buffer.writeBytes(this.two, this.twoReadIndex, length);
                }
                return buffer;
            }
            case 2: {
                return buffer.writeBytes(this.two, index, length);
            }
        }
        throw new IllegalStateException();
    }

    public ByteBuf slice(int readIndex, int length) {
        this.checkIndex(readIndex, length);
        if (readIndex == 0 && length == this.capacity) {
            return new Tuple2ByteBuf(this.allocator, this.one.slice(this.oneReadIndex, this.oneReadableBytes), this.two.slice(this.twoReadIndex, this.twoReadableBytes));
        }
        long ri = this.calculateRelativeIndex(readIndex);
        int index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                ByteBuf oneSlice = this.one.slice(index, l);
                if ((length -= l) != 0) {
                    ByteBuf twoSlice = this.two.slice(this.twoReadIndex, length);
                    return new Tuple2ByteBuf(this.allocator, oneSlice, twoSlice);
                }
                return oneSlice;
            }
            case 2: {
                return this.two.slice(index, length);
            }
        }
        throw new IllegalStateException();
    }

    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        ReferenceCountUtil.safeRelease((Object)this.one);
        ReferenceCountUtil.safeRelease((Object)this.two);
    }

    public String toString(Charset charset) {
        StringBuilder builder = new StringBuilder(3);
        builder.append(this.one.toString(charset));
        builder.append(this.two.toString(charset));
        return builder.toString();
    }

    public String toString(int index, int length, Charset charset) {
        return this.toString(charset).substring(index, length);
    }

    public String toString() {
        return "Tuple2ByteBuf{capacity=" + this.capacity + ", one=" + this.one + ", two=" + this.two + ", allocator=" + this.allocator + ", oneReadIndex=" + this.oneReadIndex + ", twoReadIndex=" + this.twoReadIndex + ", oneReadableBytes=" + this.oneReadableBytes + ", twoReadableBytes=" + this.twoReadableBytes + ", twoRelativeIndex=" + this.twoRelativeIndex + '}';
    }
}

