/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.StreamIdSupplier;
import io.rsocket.exceptions.Exceptions;
import io.rsocket.frame.CancelFrameFlyweight;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.MetadataPushFrameFlyweight;
import io.rsocket.frame.PayloadFrameFlyweight;
import io.rsocket.frame.RequestChannelFrameFlyweight;
import io.rsocket.frame.RequestFireAndForgetFrameFlyweight;
import io.rsocket.frame.RequestNFrameFlyweight;
import io.rsocket.frame.RequestResponseFrameFlyweight;
import io.rsocket.frame.RequestStreamFrameFlyweight;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.LimitableRequestPublisher;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.internal.UnicastMonoProcessor;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;

class RSocketClient
implements RSocket {
    private final DuplexConnection connection;
    private final PayloadDecoder payloadDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final StreamIdSupplier streamIdSupplier;
    private final Map<Integer, LimitableRequestPublisher> senders;
    private final Map<Integer, Processor<Payload, Payload>> receivers;
    private final UnboundedProcessor<ByteBuf> sendProcessor;
    private final Lifecycle lifecycle = new Lifecycle();
    private final ByteBufAllocator allocator;

    RSocketClient(ByteBufAllocator allocator, DuplexConnection connection, PayloadDecoder payloadDecoder, Consumer<Throwable> errorConsumer, StreamIdSupplier streamIdSupplier) {
        this.allocator = allocator;
        this.connection = connection;
        this.payloadDecoder = payloadDecoder;
        this.errorConsumer = errorConsumer;
        this.streamIdSupplier = streamIdSupplier;
        this.senders = Collections.synchronizedMap(new IntObjectHashMap());
        this.receivers = Collections.synchronizedMap(new IntObjectHashMap());
        this.sendProcessor = new UnboundedProcessor();
        connection.onClose().doFinally(signalType -> this.terminate()).subscribe(null, errorConsumer);
        this.sendProcessor.doOnRequest(r -> {
            for (LimitableRequestPublisher lrp : this.senders.values()) {
                lrp.increaseInternalLimit(r);
            }
        }).transform(connection::send).doFinally(this::handleSendProcessorCancel).subscribe(null, this::handleSendProcessorError);
        connection.receive().subscribe(this::handleIncomingFrames, errorConsumer);
    }

    private void handleSendProcessorError(Throwable t) {
        Throwable terminationError = this.lifecycle.getTerminationError();
        Throwable err = terminationError != null ? terminationError : t;
        this.receivers.values().forEach(subscriber -> {
            try {
                subscriber.onError(err);
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.senders.values().forEach(LimitableRequestPublisher::cancel);
    }

    private void handleSendProcessorCancel(SignalType t) {
        if (SignalType.ON_ERROR == t) {
            return;
        }
        this.receivers.values().forEach(subscriber -> {
            try {
                subscriber.onError(new Throwable("closed connection"));
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.senders.values().forEach(LimitableRequestPublisher::cancel);
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        return this.handleFireAndForget(payload);
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        return this.handleRequestResponse(payload);
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        return this.handleRequestStream(payload);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.handleChannel((Flux<Payload>)Flux.from(payloads));
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        return this.handleMetadataPush(payload);
    }

    @Override
    public double availability() {
        return this.connection.availability();
    }

    public void dispose() {
        this.connection.dispose();
    }

    public boolean isDisposed() {
        return this.connection.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }

    private Mono<Void> handleFireAndForget(Payload payload) {
        return this.lifecycle.active(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            ByteBuf requestFrame = RequestFireAndForgetFrameFlyweight.encode(this.allocator, streamId, false, payload.hasMetadata() ? payload.sliceMetadata().retain() : null, payload.sliceData().retain());
            payload.release();
            this.sendProcessor.onNext(requestFrame);
        });
    }

    private Mono<Payload> handleRequestResponse(Payload payload) {
        return this.lifecycle.activeMono(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
            ByteBuf requestFrame = RequestResponseFrameFlyweight.encode(this.allocator, streamId, false, payload.sliceMetadata().retain(), payload.sliceData().retain());
            payload.release();
            UnicastMonoProcessor receiver = UnicastMonoProcessor.create();
            this.receivers.put(streamId, receiver);
            sendProcessor.onNext(requestFrame);
            return receiver.doOnError(t -> sendProcessor.onNext(ErrorFrameFlyweight.encode(this.allocator, streamId, t))).doFinally(s -> {
                if (s == SignalType.CANCEL) {
                    sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId));
                }
                this.receivers.remove(streamId);
            });
        });
    }

    private Flux<Payload> handleRequestStream(final Payload payload) {
        return this.lifecycle.activeFlux(() -> {
            final int streamId = this.streamIdSupplier.nextStreamId();
            final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
            final UnicastProcessor receiver = UnicastProcessor.create();
            this.receivers.put(streamId, (Processor<Payload, Payload>)receiver);
            return receiver.doOnRequest(new LongConsumer(){
                boolean firstRequest = true;

                @Override
                public void accept(long n) {
                    if (this.firstRequest && !receiver.isDisposed()) {
                        this.firstRequest = false;
                        sendProcessor.onNext(RequestStreamFrameFlyweight.encode(RSocketClient.this.allocator, streamId, false, n, payload.sliceMetadata().retain(), payload.sliceData().retain()));
                        payload.release();
                    } else if (RSocketClient.this.contains(streamId) && !receiver.isDisposed()) {
                        sendProcessor.onNext(RequestNFrameFlyweight.encode(RSocketClient.this.allocator, streamId, n));
                    }
                }
            }).doOnError(t -> {
                if (this.contains(streamId) && !receiver.isDisposed()) {
                    sendProcessor.onNext(ErrorFrameFlyweight.encode(this.allocator, streamId, t));
                }
            }).doOnCancel(() -> {
                if (this.contains(streamId) && !receiver.isDisposed()) {
                    sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId));
                }
            }).doFinally(s -> this.receivers.remove(streamId));
        });
    }

    private Flux<Payload> handleChannel(final Flux<Payload> request) {
        return this.lifecycle.activeFlux(() -> {
            final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
            final UnicastProcessor receiver = UnicastProcessor.create();
            final int streamId = this.streamIdSupplier.nextStreamId();
            return receiver.doOnRequest(new LongConsumer(){
                boolean firstRequest = true;

                @Override
                public void accept(final long n) {
                    if (this.firstRequest) {
                        this.firstRequest = false;
                        request.transform(f -> {
                            LimitableRequestPublisher wrapped = LimitableRequestPublisher.wrap(f, sendProcessor.available());
                            wrapped.request(1L);
                            RSocketClient.this.senders.put(streamId, wrapped);
                            RSocketClient.this.receivers.put(streamId, receiver);
                            return wrapped;
                        }).subscribe((CoreSubscriber)new BaseSubscriber<Payload>(){
                            boolean firstPayload = true;

                            protected void hookOnNext(Payload payload) {
                                ByteBuf frame;
                                if (this.firstPayload) {
                                    this.firstPayload = false;
                                    frame = RequestChannelFrameFlyweight.encode(RSocketClient.this.allocator, streamId, false, false, n, payload.sliceMetadata().retain(), payload.sliceData().retain());
                                } else {
                                    frame = PayloadFrameFlyweight.encode(RSocketClient.this.allocator, streamId, false, false, true, payload);
                                }
                                sendProcessor.onNext(frame);
                                payload.release();
                            }

                            protected void hookOnComplete() {
                                if (RSocketClient.this.contains(streamId) && !receiver.isDisposed()) {
                                    sendProcessor.onNext(PayloadFrameFlyweight.encodeComplete(RSocketClient.this.allocator, streamId));
                                }
                                if (this.firstPayload) {
                                    receiver.onComplete();
                                }
                            }

                            protected void hookOnError(Throwable t) {
                                RSocketClient.this.errorConsumer.accept(t);
                                receiver.dispose();
                            }
                        });
                    } else if (RSocketClient.this.contains(streamId) && !receiver.isDisposed()) {
                        sendProcessor.onNext(RequestNFrameFlyweight.encode(RSocketClient.this.allocator, streamId, n));
                    }
                }
            }).doOnError(t -> {
                if (this.contains(streamId) && !receiver.isDisposed()) {
                    sendProcessor.onNext(ErrorFrameFlyweight.encode(this.allocator, streamId, t));
                }
            }).doOnCancel(() -> {
                if (this.contains(streamId) && !receiver.isDisposed()) {
                    sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId));
                }
            }).doFinally(s -> {
                this.receivers.remove(streamId);
                LimitableRequestPublisher sender = this.senders.remove(streamId);
                if (sender != null) {
                    sender.cancel();
                }
            });
        });
    }

    private Mono<Void> handleMetadataPush(Payload payload) {
        return this.lifecycle.active(() -> this.sendProcessor.onNext(MetadataPushFrameFlyweight.encode(this.allocator, payload.sliceMetadata().retain())));
    }

    private boolean contains(int streamId) {
        return this.receivers.containsKey(streamId);
    }

    protected void terminate() {
        this.lifecycle.setTerminationError(new ClosedChannelException());
        try {
            this.receivers.values().forEach(this::cleanUpSubscriber);
            this.senders.values().forEach(this::cleanUpLimitableRequestPublisher);
        }
        finally {
            this.senders.clear();
            this.receivers.clear();
            this.sendProcessor.dispose();
        }
    }

    private synchronized void cleanUpLimitableRequestPublisher(LimitableRequestPublisher<?> limitableRequestPublisher) {
        try {
            limitableRequestPublisher.cancel();
        }
        catch (Throwable t) {
            this.errorConsumer.accept(t);
        }
    }

    private synchronized void cleanUpSubscriber(Processor subscriber) {
        try {
            subscriber.onError(this.lifecycle.getTerminationError());
        }
        catch (Throwable t) {
            this.errorConsumer.accept(t);
        }
    }

    private void handleIncomingFrames(ByteBuf frame) {
        try {
            int streamId = FrameHeaderFlyweight.streamId(frame);
            FrameType type = FrameHeaderFlyweight.frameType(frame);
            if (streamId == 0) {
                this.handleStreamZero(type, frame);
            } else {
                this.handleFrame(streamId, type, frame);
            }
            frame.release();
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)frame);
            throw reactor.core.Exceptions.propagate((Throwable)t);
        }
    }

    private void handleStreamZero(FrameType type, ByteBuf frame) {
        switch (type) {
            case ERROR: {
                RuntimeException error = Exceptions.from(frame);
                this.lifecycle.setTerminationError(error);
                this.errorConsumer.accept(error);
                this.connection.dispose();
                break;
            }
            case LEASE: {
                break;
            }
            case KEEPALIVE: {
                break;
            }
            default: {
                this.errorConsumer.accept(new IllegalStateException("Client received supported frame on stream 0: " + frame.toString()));
            }
        }
    }

    private void handleFrame(int streamId, FrameType type, ByteBuf frame) {
        Subscriber receiver = (Subscriber)this.receivers.get(streamId);
        if (receiver == null) {
            this.handleMissingResponseProcessor(streamId, type, frame);
        } else {
            switch (type) {
                case ERROR: {
                    receiver.onError((Throwable)Exceptions.from(frame));
                    this.receivers.remove(streamId);
                    break;
                }
                case NEXT_COMPLETE: {
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    receiver.onComplete();
                    break;
                }
                case CANCEL: {
                    LimitableRequestPublisher sender = this.senders.remove(streamId);
                    if (sender == null) break;
                    sender.cancel();
                    break;
                }
                case NEXT: {
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    break;
                }
                case REQUEST_N: {
                    LimitableRequestPublisher sender = this.senders.get(streamId);
                    if (sender == null) break;
                    int n = RequestNFrameFlyweight.requestN(frame);
                    sender.request(n >= Integer.MAX_VALUE ? Long.MAX_VALUE : (long)n);
                    break;
                }
                case COMPLETE: {
                    receiver.onComplete();
                    this.receivers.remove(streamId);
                    break;
                }
                default: {
                    throw new IllegalStateException("Client received supported frame on stream " + streamId + ": " + frame.toString());
                }
            }
        }
    }

    private void handleMissingResponseProcessor(int streamId, FrameType type, ByteBuf frame) {
        if (!this.streamIdSupplier.isBeforeOrCurrent(streamId)) {
            if (type == FrameType.ERROR) {
                String errorMessage = ErrorFrameFlyweight.dataUtf8(frame);
                throw new IllegalStateException("Client received error for non-existent stream: " + streamId + " Message: " + errorMessage);
            }
            throw new IllegalStateException("Client received message for non-existent stream: " + streamId + ", frame type: " + (Object)((Object)type));
        }
    }

    private static class Lifecycle {
        private static final AtomicReferenceFieldUpdater<Lifecycle, Throwable> TERMINATION_ERROR = AtomicReferenceFieldUpdater.newUpdater(Lifecycle.class, Throwable.class, "terminationError");
        private volatile Throwable terminationError;

        private Lifecycle() {
        }

        public Mono<Void> active(Runnable runnable) {
            return Mono.create(sink -> {
                if (this.terminationError == null) {
                    runnable.run();
                    sink.success();
                } else {
                    sink.error(this.terminationError);
                }
            });
        }

        public <T> Mono<T> activeMono(Supplier<? extends Mono<? extends T>> supplier) {
            return Mono.defer(() -> {
                if (this.terminationError == null) {
                    return (Mono)supplier.get();
                }
                return Mono.error((Throwable)this.terminationError);
            });
        }

        public <T> Flux<T> activeFlux(Supplier<? extends Flux<T>> supplier) {
            return Flux.defer(() -> {
                if (this.terminationError == null) {
                    return (Publisher)supplier.get();
                }
                return Flux.error((Throwable)this.terminationError);
            });
        }

        public Throwable getTerminationError() {
            return this.terminationError;
        }

        public void setTerminationError(Throwable err) {
            TERMINATION_ERROR.compareAndSet(this, null, err);
        }
    }
}

