/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;

class DataAndMetadataFlyweight {
    public static final int FRAME_LENGTH_MASK = 0xFFFFFF;

    private DataAndMetadataFlyweight() {
    }

    private static void encodeLength(ByteBuf byteBuf, int length) {
        if ((length & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Length is larger than 24 bits");
        }
        byteBuf.writeByte(length >> 16);
        byteBuf.writeByte(length >> 8);
        byteBuf.writeByte(length);
    }

    private static int decodeLength(ByteBuf byteBuf) {
        byte b = byteBuf.readByte();
        int length = (b & 0xFF) << 16;
        byte b1 = byteBuf.readByte();
        length |= (b1 & 0xFF) << 8;
        byte b2 = byteBuf.readByte();
        return length |= b2 & 0xFF;
    }

    static ByteBuf encodeOnlyMetadata(ByteBufAllocator allocator, ByteBuf header, ByteBuf metadata) {
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, metadata});
    }

    static ByteBuf encodeOnlyData(ByteBufAllocator allocator, ByteBuf header, ByteBuf data) {
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, data});
    }

    static ByteBuf encode(ByteBufAllocator allocator, ByteBuf header, ByteBuf metadata, ByteBuf data) {
        int length = metadata.readableBytes();
        DataAndMetadataFlyweight.encodeLength(header, length);
        return allocator.compositeBuffer(3).addComponents(true, new ByteBuf[]{header, metadata, data});
    }

    static ByteBuf metadataWithoutMarking(ByteBuf byteBuf, boolean hasMetadata) {
        if (hasMetadata) {
            int length = DataAndMetadataFlyweight.decodeLength(byteBuf);
            return byteBuf.readSlice(length);
        }
        return Unpooled.EMPTY_BUFFER;
    }

    static ByteBuf metadata(ByteBuf byteBuf, boolean hasMetadata) {
        byteBuf.markReaderIndex();
        ByteBuf metadata = DataAndMetadataFlyweight.metadataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return metadata;
    }

    static ByteBuf dataWithoutMarking(ByteBuf byteBuf, boolean hasMetadata) {
        if (hasMetadata) {
            int length = DataAndMetadataFlyweight.decodeLength(byteBuf);
            byteBuf.skipBytes(length);
        }
        if (byteBuf.readableBytes() > 0) {
            return byteBuf.slice();
        }
        return Unpooled.EMPTY_BUFFER;
    }

    static ByteBuf data(ByteBuf byteBuf, boolean hasMetadata) {
        byteBuf.markReaderIndex();
        ByteBuf data = DataAndMetadataFlyweight.dataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return data;
    }
}

