/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.rsocket.frame.DataAndMetadataFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.VersionFlyweight;
import java.nio.charset.StandardCharsets;

public class SetupFrameFlyweight {
    public static final int FLAGS_RESUME_ENABLE = 128;
    public static final int FLAGS_WILL_HONOR_LEASE = 64;
    public static final int CURRENT_VERSION = VersionFlyweight.encode(1, 0);
    private static final int VERSION_FIELD_OFFSET = FrameHeaderFlyweight.size();
    private static final int KEEPALIVE_INTERVAL_FIELD_OFFSET = VERSION_FIELD_OFFSET + 4;
    private static final int KEEPALIVE_MAX_LIFETIME_FIELD_OFFSET = KEEPALIVE_INTERVAL_FIELD_OFFSET + 4;
    private static final int VARIABLE_DATA_OFFSET = KEEPALIVE_MAX_LIFETIME_FIELD_OFFSET + 4;

    public static ByteBuf encode(ByteBufAllocator allocator, boolean lease, boolean resume, int keepaliveInterval, int maxLifetime, String metadataMimeType, String dataMimeType, ByteBuf metadata, ByteBuf data) {
        return SetupFrameFlyweight.encode(allocator, lease, resume, keepaliveInterval, maxLifetime, Unpooled.EMPTY_BUFFER, metadataMimeType, dataMimeType, metadata, data);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, boolean lease, boolean resume, int keepaliveInterval, int maxLifetime, ByteBuf resumeToken, String metadataMimeType, String dataMimeType, ByteBuf metadata, ByteBuf data) {
        int flags = 0;
        if (resume) {
            throw new IllegalArgumentException("RESUME_ENABLE not supported");
        }
        if (lease) {
            flags |= 0x40;
        }
        if (metadata != null) {
            flags |= 0x100;
        }
        ByteBuf header = FrameHeaderFlyweight.encodeStreamZero(allocator, FrameType.SETUP, flags);
        header.writeInt(CURRENT_VERSION).writeInt(keepaliveInterval).writeInt(maxLifetime);
        if ((flags & 0x80) != 0) {
            header.writeShort(resumeToken.readableBytes()).writeBytes(resumeToken);
        }
        int length = ByteBufUtil.utf8Bytes((CharSequence)metadataMimeType);
        header.writeByte(length);
        ByteBufUtil.writeUtf8((ByteBuf)header, (CharSequence)metadataMimeType);
        length = ByteBufUtil.utf8Bytes((CharSequence)dataMimeType);
        header.writeByte(length);
        ByteBufUtil.writeUtf8((ByteBuf)header, (CharSequence)dataMimeType);
        if (metadata != null) {
            return DataAndMetadataFlyweight.encode(allocator, header, metadata, data);
        }
        return DataAndMetadataFlyweight.encodeOnlyData(allocator, header, data);
    }

    public static int version(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.SETUP, byteBuf);
        byteBuf.markReaderIndex();
        int version = byteBuf.skipBytes(VERSION_FIELD_OFFSET).readInt();
        byteBuf.resetReaderIndex();
        return version;
    }

    public static int resumeTokenLength(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int tokenLength = byteBuf.skipBytes(VARIABLE_DATA_OFFSET).readShort() & 0xFFFF;
        byteBuf.resetReaderIndex();
        return tokenLength;
    }

    public static int keepAliveInterval(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int keepAliveInterval = byteBuf.skipBytes(KEEPALIVE_INTERVAL_FIELD_OFFSET).readInt();
        byteBuf.resetReaderIndex();
        return keepAliveInterval;
    }

    public static int keepAliveMaxLifetime(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int keepAliveMaxLifetime = byteBuf.skipBytes(KEEPALIVE_MAX_LIFETIME_FIELD_OFFSET).readInt();
        byteBuf.resetReaderIndex();
        return keepAliveMaxLifetime;
    }

    public static boolean honorLease(ByteBuf byteBuf) {
        return (0x40 & FrameHeaderFlyweight.flags(byteBuf)) == 64;
    }

    public static boolean resumeEnabled(ByteBuf byteBuf) {
        return (0x80 & FrameHeaderFlyweight.flags(byteBuf)) == 128;
    }

    public static String metadataMimeType(ByteBuf byteBuf) {
        int skip = SetupFrameFlyweight.bytesToSkipToMimeType(byteBuf);
        byteBuf.markReaderIndex();
        byte length = byteBuf.skipBytes(skip).readByte();
        String mimeType = byteBuf.readSlice((int)length).toString(StandardCharsets.UTF_8);
        byteBuf.resetReaderIndex();
        return mimeType;
    }

    public static String dataMimeType(ByteBuf byteBuf) {
        int skip = SetupFrameFlyweight.bytesToSkipToMimeType(byteBuf);
        byteBuf.markReaderIndex();
        byte metadataLength = byteBuf.skipBytes(skip).readByte();
        byte dataLength = byteBuf.skipBytes((int)metadataLength).readByte();
        String mimeType = byteBuf.readSlice((int)dataLength).toString(StandardCharsets.UTF_8);
        byteBuf.resetReaderIndex();
        return mimeType;
    }

    public static ByteBuf metadata(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderFlyweight.hasMetadata(byteBuf);
        byteBuf.markReaderIndex();
        SetupFrameFlyweight.skipToPayload(byteBuf);
        ByteBuf metadata = DataAndMetadataFlyweight.metadataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return metadata;
    }

    public static ByteBuf data(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderFlyweight.hasMetadata(byteBuf);
        byteBuf.markReaderIndex();
        SetupFrameFlyweight.skipToPayload(byteBuf);
        ByteBuf data = DataAndMetadataFlyweight.dataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return data;
    }

    private static int bytesToSkipToMimeType(ByteBuf byteBuf) {
        int bytesToSkip = VARIABLE_DATA_OFFSET;
        if ((0x80 & FrameHeaderFlyweight.flags(byteBuf)) == 128) {
            bytesToSkip = SetupFrameFlyweight.resumeTokenLength(byteBuf) + 2;
        }
        return bytesToSkip;
    }

    private static void skipToPayload(ByteBuf byteBuf) {
        int skip = SetupFrameFlyweight.bytesToSkipToMimeType(byteBuf);
        byte length = byteBuf.skipBytes(skip).readByte();
        length = byteBuf.skipBytes((int)length).readByte();
        byteBuf.skipBytes((int)length);
    }
}

