/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.framing.LengthUtils;
import io.rsocket.util.NumberUtils;
import io.rsocket.util.RecyclerFactory;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;

public final class ResumeFrame
extends AbstractRecyclableFrame<ResumeFrame> {
    private static final int OFFSET_MAJOR_VERSION = 2;
    private static final int OFFSET_MINOR_VERSION = 4;
    private static final int OFFSET_TOKEN_LENGTH = 6;
    private static final int OFFSET_RESUME_IDENTIFICATION_TOKEN = 8;
    private static final Recycler<ResumeFrame> RECYCLER = RecyclerFactory.createRecycler(ResumeFrame::new);

    private ResumeFrame(Recycler.Handle<ResumeFrame> handle) {
        super(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResumeFrame createResumeFrame(ByteBufAllocator byteBufAllocator, String resumeIdentificationToken, long lastReceivedServerPosition, long firstAvailableClientPosition) {
        ByteBuf resumeIdentificationTokenByteBuf = ResumeFrame.getUtf8AsByteBufRequired(resumeIdentificationToken, "resumeIdentificationToken must not be null");
        try {
            ResumeFrame resumeFrame = ResumeFrame.createResumeFrame(byteBufAllocator, resumeIdentificationTokenByteBuf, lastReceivedServerPosition, firstAvailableClientPosition);
            return resumeFrame;
        }
        finally {
            ReferenceCountUtil.release((Object)resumeIdentificationToken);
        }
    }

    public static ResumeFrame createResumeFrame(ByteBufAllocator byteBufAllocator, ByteBuf resumeIdentificationToken, long lastReceivedServerPosition, long firstAvailableClientPosition) {
        return ResumeFrame.createResumeFrame(byteBufAllocator, 1, 0, resumeIdentificationToken, lastReceivedServerPosition, firstAvailableClientPosition);
    }

    public static ResumeFrame createResumeFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (ResumeFrame)((ResumeFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    public static ResumeFrame createResumeFrame(ByteBufAllocator byteBufAllocator, int majorVersion, int minorVersion, ByteBuf resumeIdentificationToken, long lastReceivedServerPosition, long firstAvailableClientPosition) {
        Objects.requireNonNull(resumeIdentificationToken, "resumeIdentificationToken must not be null");
        ByteBuf byteBuf = ResumeFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.RESUME).writeShort(NumberUtils.requireUnsignedShort(majorVersion)).writeShort(NumberUtils.requireUnsignedShort(minorVersion));
        byteBuf = byteBuf.writeShort(LengthUtils.getLengthAsUnsignedShort(resumeIdentificationToken));
        byteBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, resumeIdentificationToken.retain(), byteBufAllocator.buffer()});
        byteBuf = byteBuf.writeLong(lastReceivedServerPosition).writeLong(firstAvailableClientPosition);
        return (ResumeFrame)((ResumeFrame)RECYCLER.get()).setByteBuf(byteBuf);
    }

    public long getFirstAvailableClientPosition() {
        return this.getByteBuf().getLong(this.getFirstAvailableClientPositionOffset());
    }

    public long getLastReceivedServerPosition() {
        return this.getByteBuf().getLong(this.getLastReceivedServerPositionOffset());
    }

    public int getMajorVersion() {
        return this.getByteBuf().getUnsignedShort(2);
    }

    public int getMinorVersion() {
        return this.getByteBuf().getUnsignedShort(4);
    }

    public String getResumeIdentificationTokenAsUtf8() {
        return this.mapResumeIdentificationToken(byteBuf -> byteBuf.toString(StandardCharsets.UTF_8));
    }

    public ByteBuf getUnsafeResumeIdentificationToken() {
        return this.getByteBuf().slice(8, this.getTokenLength());
    }

    public <T> T mapResumeIdentificationToken(Function<ByteBuf, T> function) {
        Objects.requireNonNull(function, "function must not be null");
        return function.apply(this.getUnsafeResumeIdentificationToken());
    }

    public String toString() {
        return "ResumeFrame{majorVersion=" + this.getMajorVersion() + ", minorVersion=" + this.getMinorVersion() + ", resumeIdentificationToken=" + this.mapResumeIdentificationToken(ByteBufUtil::hexDump) + ", lastReceivedServerPosition=" + this.getLastReceivedServerPosition() + ", firstAvailableClientPosition=" + this.getFirstAvailableClientPosition() + '}';
    }

    private int getFirstAvailableClientPositionOffset() {
        return this.getLastReceivedServerPositionOffset() + 8;
    }

    private int getLastReceivedServerPositionOffset() {
        return 8 + this.getTokenLength();
    }

    private int getTokenLength() {
        return this.getByteBuf().getUnsignedShort(6);
    }
}

