/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.rsocket.Frame;
import io.rsocket.resume.ResumePositionCounter;
import io.rsocket.resume.ResumeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import reactor.core.publisher.Flux;

public class ResumeCache {
    private final ResumePositionCounter strategy;
    private final int maxBufferSize;
    private final LinkedHashMap<Integer, Frame> frames = new LinkedHashMap();
    private int lastRemotePosition = 0;
    private int currentPosition = 0;
    private int bufferSize;

    public ResumeCache(ResumePositionCounter strategy, int maxBufferSize) {
        this.strategy = strategy;
        this.maxBufferSize = maxBufferSize;
    }

    public void updateRemotePosition(int remotePosition) {
        if (remotePosition > this.currentPosition) {
            throw new IllegalStateException("Remote ahead of " + this.lastRemotePosition + " , expected " + remotePosition);
        }
        if (remotePosition == this.lastRemotePosition) {
            return;
        }
        if (remotePosition < this.lastRemotePosition) {
            throw new IllegalStateException("Remote position moved back from " + this.lastRemotePosition + " to " + remotePosition);
        }
        this.lastRemotePosition = remotePosition;
        Iterator<Map.Entry<Integer, Frame>> positions = this.frames.entrySet().iterator();
        while (positions.hasNext()) {
            Map.Entry<Integer, Frame> cachePosition = positions.next();
            if (cachePosition.getKey() > remotePosition) continue;
            positions.remove();
            this.bufferSize -= this.strategy.cost(cachePosition.getValue());
            cachePosition.getValue().release();
        }
    }

    public void sent(Frame frame) {
        if (ResumeUtil.isTracked(frame)) {
            this.frames.put(this.currentPosition, frame.copy());
            this.bufferSize += this.strategy.cost(frame);
            this.currentPosition += ResumeUtil.offset(frame);
            if (this.frames.size() > this.maxBufferSize) {
                Frame f = (Frame)this.frames.remove(this.first(this.frames));
                this.bufferSize -= this.strategy.cost(f);
            }
        }
    }

    private int first(LinkedHashMap<Integer, Frame> frames) {
        return frames.keySet().iterator().next();
    }

    public Flux<Frame> resend(int remotePosition) {
        this.updateRemotePosition(remotePosition);
        if (remotePosition == this.currentPosition) {
            return Flux.empty();
        }
        ArrayList<Frame> resend = new ArrayList<Frame>();
        for (Map.Entry<Integer, Frame> cachePosition : this.frames.entrySet()) {
            if (remotePosition >= cachePosition.getKey()) continue;
            resend.add(cachePosition.getValue());
        }
        return Flux.fromIterable(resend);
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public int getRemotePosition() {
        return this.lastRemotePosition;
    }

    public int getEarliestResendPosition() {
        if (this.frames.isEmpty()) {
            return this.currentPosition;
        }
        return this.first(this.frames);
    }

    public int size() {
        return this.bufferSize;
    }
}

