/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.util;

import java.util.Objects;

public final class NumberUtils {
    public static final int MEDIUM_BYTES = 3;
    private static final int UNSIGNED_BYTE_SIZE = 8;
    private static final int UNSIGNED_BYTE_MAX_VALUE = 255;
    private static final int UNSIGNED_MEDIUM_SIZE = 24;
    private static final int UNSIGNED_MEDIUM_MAX_VALUE = 0xFFFFFF;
    private static final int UNSIGNED_SHORT_SIZE = 16;
    private static final int UNSIGNED_SHORT_MAX_VALUE = 65535;

    private NumberUtils() {
    }

    public static long requirePositive(long l, String message) {
        Objects.requireNonNull(message, "message must not be null");
        if (l <= 0L) {
            throw new IllegalArgumentException(message);
        }
        return l;
    }

    public static int requirePositive(int i, String message) {
        Objects.requireNonNull(message, "message must not be null");
        if (i <= 0) {
            throw new IllegalArgumentException(message);
        }
        return i;
    }

    public static int requireUnsignedByte(int i) {
        if (i > 255) {
            throw new IllegalArgumentException(String.format("%d is larger than %d bits", i, 8));
        }
        return i;
    }

    public static int requireUnsignedMedium(int i) {
        if (i > 0xFFFFFF) {
            throw new IllegalArgumentException(String.format("%d is larger than %d bits", i, 24));
        }
        return i;
    }

    public static int requireUnsignedShort(int i) {
        if (i > 65535) {
            throw new IllegalArgumentException(String.format("%d is larger than %d bits", i, 16));
        }
        return i;
    }
}

