/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.metrics.om;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.opentracing.Tracer;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.rpc.annotations.internal.Generated;
import io.rsocket.rpc.annotations.internal.GeneratedMethod;
import io.rsocket.rpc.annotations.internal.ResourceType;
import io.rsocket.rpc.frames.Metadata;
import io.rsocket.rpc.metrics.Metrics;
import io.rsocket.rpc.metrics.om.MetricsSnapshot;
import io.rsocket.rpc.metrics.om.MetricsSnapshotHandler;
import io.rsocket.rpc.metrics.om.Skew;
import io.rsocket.rpc.tracing.Tag;
import io.rsocket.rpc.tracing.Tracing;
import io.rsocket.util.ByteBufPayload;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Generated(type=ResourceType.CLIENT, idlClass=MetricsSnapshotHandler.class)
public final class MetricsSnapshotHandlerClient
implements MetricsSnapshotHandler {
    private final RSocket rSocket;
    private final Function<? super Publisher<Skew>, ? extends Publisher<Skew>> streamMetrics;
    private final Function<Map<String, String>, Function<? super Publisher<Skew>, ? extends Publisher<Skew>>> streamMetricsTrace;

    public MetricsSnapshotHandlerClient(RSocket rSocket) {
        this.rSocket = rSocket;
        this.streamMetrics = Function.identity();
        this.streamMetricsTrace = Tracing.trace();
    }

    public MetricsSnapshotHandlerClient(RSocket rSocket, MeterRegistry registry) {
        this.rSocket = rSocket;
        this.streamMetrics = Metrics.timed(registry, "rsocket.client", "service", "io.rsocket.rpc.metrics.om.MetricsSnapshotHandler", "method", "StreamMetrics");
        this.streamMetricsTrace = Tracing.trace();
    }

    public MetricsSnapshotHandlerClient(RSocket rSocket, Tracer tracer) {
        this.rSocket = rSocket;
        this.streamMetrics = Function.identity();
        this.streamMetricsTrace = Tracing.trace(tracer, "StreamMetrics", Tag.of("rsocket.service", "io.rsocket.rpc.metrics.om.MetricsSnapshotHandler"), Tag.of("rsocket.rpc.role", "client"), Tag.of("rsocket.rpc.version", ""));
    }

    public MetricsSnapshotHandlerClient(RSocket rSocket, MeterRegistry registry, Tracer tracer) {
        this.rSocket = rSocket;
        this.streamMetrics = Metrics.timed(registry, "rsocket.client", "service", "io.rsocket.rpc.metrics.om.MetricsSnapshotHandler", "method", "StreamMetrics");
        this.streamMetricsTrace = Tracing.trace(tracer, "StreamMetrics", Tag.of("rsocket.service", "io.rsocket.rpc.metrics.om.MetricsSnapshotHandler"), Tag.of("rsocket.rpc.role", "client"), Tag.of("rsocket.rpc.version", ""));
    }

    @GeneratedMethod(returnTypeClass=Skew.class)
    public Flux<Skew> streamMetrics(Publisher<MetricsSnapshot> messages) {
        return this.streamMetrics(messages, Unpooled.EMPTY_BUFFER);
    }

    @Override
    @GeneratedMethod(returnTypeClass=Skew.class)
    public Flux<Skew> streamMetrics(Publisher<MetricsSnapshot> messages, final ByteBuf metadata) {
        HashMap map = new HashMap();
        return this.rSocket.requestChannel((Publisher)Flux.from(messages).map((Function)new Function<MessageLite, Payload>(){
            private final AtomicBoolean once = new AtomicBoolean(false);

            @Override
            public Payload apply(MessageLite message) {
                ByteBuf data = MetricsSnapshotHandlerClient.serialize(message);
                if (this.once.compareAndSet(false, true)) {
                    ByteBuf metadataBuf = Metadata.encode(ByteBufAllocator.DEFAULT, "io.rsocket.rpc.metrics.om.MetricsSnapshotHandler", "StreamMetrics", metadata);
                    return ByteBufPayload.create((ByteBuf)data, (ByteBuf)metadataBuf);
                }
                return ByteBufPayload.create((ByteBuf)data);
            }
        })).map(MetricsSnapshotHandlerClient.deserializer(Skew.parser())).transform(this.streamMetrics).transform(this.streamMetricsTrace.apply(map));
    }

    private static ByteBuf serialize(MessageLite message) {
        int length = message.getSerializedSize();
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(length);
        try {
            message.writeTo(CodedOutputStream.newInstance((ByteBuffer)byteBuf.internalNioBuffer(0, length)));
            byteBuf.writerIndex(length);
            return byteBuf;
        }
        catch (Throwable t) {
            byteBuf.release();
            throw new RuntimeException(t);
        }
    }

    private static <T> Function<Payload, T> deserializer(final Parser<T> parser) {
        return new Function<Payload, T>(){

            @Override
            public T apply(Payload payload) {
                try {
                    CodedInputStream is = CodedInputStream.newInstance((ByteBuffer)payload.getData());
                    Object object = parser.parseFrom(is);
                    return object;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                finally {
                    payload.release();
                }
            }
        };
    }
}

