/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class MetricsFuseableSubscriber<T>
extends AtomicBoolean
implements Fuseable.QueueSubscription<T>,
CoreSubscriber<T> {
    private final CoreSubscriber<? super T> actual;
    private final Counter next;
    private final Counter complete;
    private final Counter error;
    private final Counter cancelled;
    private final Timer timer;
    private Fuseable.QueueSubscription<T> s;
    private int sourceMode;
    private long start;

    MetricsFuseableSubscriber(CoreSubscriber<? super T> actual, Counter next, Counter complete, Counter error, Counter cancelled, Timer timer) {
        this.actual = actual;
        this.next = next;
        this.complete = complete;
        this.error = error;
        this.cancelled = cancelled;
        this.timer = timer;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.s, (Subscription)s)) {
            this.s = (Fuseable.QueueSubscription)s;
            this.start = System.nanoTime();
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(T t) {
        if (this.sourceMode == 2) {
            this.actual.onNext(null);
        } else {
            this.next.increment();
            this.actual.onNext(t);
        }
    }

    public void onError(Throwable t) {
        if (this.compareAndSet(false, true)) {
            this.error.increment();
            this.timer.record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.compareAndSet(false, true)) {
            this.complete.increment();
            this.timer.record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
        this.actual.onComplete();
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        if (this.compareAndSet(false, true)) {
            this.cancelled.increment();
            this.timer.record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
        this.s.cancel();
    }

    public Context currentContext() {
        return this.actual.currentContext();
    }

    public int requestFusion(int requestedMode) {
        int m;
        if ((requestedMode & 4) != 0) {
            return 0;
        }
        this.sourceMode = m = this.s.requestFusion(requestedMode);
        return m;
    }

    @Nullable
    public T poll() {
        Object v = this.s.poll();
        if (v != null) {
            this.next.increment();
            return (T)v;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.s.isEmpty();
    }

    public void clear() {
        this.s.clear();
    }

    public int size() {
        return this.s.size();
    }
}

